@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialApiKeyCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiKey Contains API key credential information.
 */
public data class AppAuthorizationCredentialApiKeyCredentialArgs(
    public val apiKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialApiKeyCredentialArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialApiKeyCredentialArgs =
        com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialApiKeyCredentialArgs.builder()
            .apiKey(apiKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppAuthorizationCredentialApiKeyCredentialArgs].
 */
@PulumiTagMarker
public class AppAuthorizationCredentialApiKeyCredentialArgsBuilder internal constructor() {
    private var apiKey: Output<String>? = null

    /**
     * @param value Contains API key credential information.
     */
    @JvmName("mgqdshytpgsptoxs")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value Contains API key credential information.
     */
    @JvmName("cngrdpvbsjqwqfce")
    public suspend fun apiKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    internal fun build(): AppAuthorizationCredentialApiKeyCredentialArgs =
        AppAuthorizationCredentialApiKeyCredentialArgs(
            apiKey = apiKey ?: throw PulumiNullFieldException("apiKey"),
        )
}
