@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiKeyCredentials Contains API key credential information.
 * @property oauth2Credential Contains OAuth2 client credential information.
 */
public data class AppAuthorizationCredentialArgs(
    public val apiKeyCredentials: Output<List<AppAuthorizationCredentialApiKeyCredentialArgs>>? =
        null,
    public val oauth2Credential: Output<AppAuthorizationCredentialOauth2CredentialArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialArgs =
        com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialArgs.builder()
            .apiKeyCredentials(
                apiKeyCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .oauth2Credential(
                oauth2Credential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AppAuthorizationCredentialArgs].
 */
@PulumiTagMarker
public class AppAuthorizationCredentialArgsBuilder internal constructor() {
    private var apiKeyCredentials: Output<List<AppAuthorizationCredentialApiKeyCredentialArgs>>? =
        null

    private var oauth2Credential: Output<AppAuthorizationCredentialOauth2CredentialArgs>? = null

    /**
     * @param value Contains API key credential information.
     */
    @JvmName("xbcxlngqbjihurqo")
    public suspend fun apiKeyCredentials(`value`: Output<List<AppAuthorizationCredentialApiKeyCredentialArgs>>) {
        this.apiKeyCredentials = value
    }

    @JvmName("tqudfriqfnnxaykt")
    public suspend fun apiKeyCredentials(vararg values: Output<AppAuthorizationCredentialApiKeyCredentialArgs>) {
        this.apiKeyCredentials = Output.all(values.asList())
    }

    /**
     * @param values Contains API key credential information.
     */
    @JvmName("cvipdoftebjbdqsw")
    public suspend fun apiKeyCredentials(values: List<Output<AppAuthorizationCredentialApiKeyCredentialArgs>>) {
        this.apiKeyCredentials = Output.all(values)
    }

    /**
     * @param value Contains OAuth2 client credential information.
     */
    @JvmName("olarvrpqwsbamjhh")
    public suspend fun oauth2Credential(`value`: Output<AppAuthorizationCredentialOauth2CredentialArgs>) {
        this.oauth2Credential = value
    }

    /**
     * @param value Contains API key credential information.
     */
    @JvmName("gjjvstlaqpjybypa")
    public suspend fun apiKeyCredentials(`value`: List<AppAuthorizationCredentialApiKeyCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKeyCredentials = mapped
    }

    /**
     * @param argument Contains API key credential information.
     */
    @JvmName("lbrxfgwdugqsqrtj")
    public suspend fun apiKeyCredentials(argument: List<suspend AppAuthorizationCredentialApiKeyCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AppAuthorizationCredentialApiKeyCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apiKeyCredentials = mapped
    }

    /**
     * @param argument Contains API key credential information.
     */
    @JvmName("wfxnpdfsnqttmjkd")
    public suspend fun apiKeyCredentials(vararg argument: suspend AppAuthorizationCredentialApiKeyCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AppAuthorizationCredentialApiKeyCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.apiKeyCredentials = mapped
    }

    /**
     * @param argument Contains API key credential information.
     */
    @JvmName("nqvhsmabusbtgpie")
    public suspend fun apiKeyCredentials(argument: suspend AppAuthorizationCredentialApiKeyCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AppAuthorizationCredentialApiKeyCredentialArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.apiKeyCredentials = mapped
    }

    /**
     * @param values Contains API key credential information.
     */
    @JvmName("xrtfvkxqibflfqbt")
    public suspend fun apiKeyCredentials(vararg values: AppAuthorizationCredentialApiKeyCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKeyCredentials = mapped
    }

    /**
     * @param value Contains OAuth2 client credential information.
     */
    @JvmName("wdtmmbinuhrnvldf")
    public suspend fun oauth2Credential(`value`: AppAuthorizationCredentialOauth2CredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauth2Credential = mapped
    }

    /**
     * @param argument Contains OAuth2 client credential information.
     */
    @JvmName("ytaylmyencvgqxrl")
    public suspend fun oauth2Credential(argument: suspend AppAuthorizationCredentialOauth2CredentialArgsBuilder.() -> Unit) {
        val toBeMapped = AppAuthorizationCredentialOauth2CredentialArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.oauth2Credential = mapped
    }

    internal fun build(): AppAuthorizationCredentialArgs = AppAuthorizationCredentialArgs(
        apiKeyCredentials = apiKeyCredentials,
        oauth2Credential = oauth2Credential,
    )
}
