@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialOauth2CredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId The client ID of the client application.
 * @property clientSecret The client secret of the client application.
 */
public data class AppAuthorizationCredentialOauth2CredentialArgs(
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialOauth2CredentialArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialOauth2CredentialArgs =
        com.pulumi.aws.appfabric.inputs.AppAuthorizationCredentialOauth2CredentialArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppAuthorizationCredentialOauth2CredentialArgs].
 */
@PulumiTagMarker
public class AppAuthorizationCredentialOauth2CredentialArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    /**
     * @param value The client ID of the client application.
     */
    @JvmName("gpxxckifvjjuivtk")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The client secret of the client application.
     */
    @JvmName("vtubyjtcrctgreom")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value The client ID of the client application.
     */
    @JvmName("ygbwbxhphtiivpoq")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret of the client application.
     */
    @JvmName("vycxrxbfdeigcyyn")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    internal fun build(): AppAuthorizationCredentialOauth2CredentialArgs =
        AppAuthorizationCredentialOauth2CredentialArgs(
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
        )
}
