@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.AppAuthorizationTenantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property tenantDisplayName The display name of the tenant.
 * @property tenantIdentifier The ID of the application tenant.
 */
public data class AppAuthorizationTenantArgs(
    public val tenantDisplayName: Output<String>,
    public val tenantIdentifier: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appfabric.inputs.AppAuthorizationTenantArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.AppAuthorizationTenantArgs =
        com.pulumi.aws.appfabric.inputs.AppAuthorizationTenantArgs.builder()
            .tenantDisplayName(tenantDisplayName.applyValue({ args0 -> args0 }))
            .tenantIdentifier(tenantIdentifier.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppAuthorizationTenantArgs].
 */
@PulumiTagMarker
public class AppAuthorizationTenantArgsBuilder internal constructor() {
    private var tenantDisplayName: Output<String>? = null

    private var tenantIdentifier: Output<String>? = null

    /**
     * @param value The display name of the tenant.
     */
    @JvmName("qlsdwknsgqqrcyyc")
    public suspend fun tenantDisplayName(`value`: Output<String>) {
        this.tenantDisplayName = value
    }

    /**
     * @param value The ID of the application tenant.
     */
    @JvmName("omugndewksarfwmg")
    public suspend fun tenantIdentifier(`value`: Output<String>) {
        this.tenantIdentifier = value
    }

    /**
     * @param value The display name of the tenant.
     */
    @JvmName("totbdmfybpittmwg")
    public suspend fun tenantDisplayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantDisplayName = mapped
    }

    /**
     * @param value The ID of the application tenant.
     */
    @JvmName("dwslvdovdroanasa")
    public suspend fun tenantIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantIdentifier = mapped
    }

    internal fun build(): AppAuthorizationTenantArgs = AppAuthorizationTenantArgs(
        tenantDisplayName = tenantDisplayName ?: throw PulumiNullFieldException("tenantDisplayName"),
        tenantIdentifier = tenantIdentifier ?: throw PulumiNullFieldException("tenantIdentifier"),
    )
}
