@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property auditLog Contains information about an audit log processing configuration.
 */
public data class IngestionDestinationDestinationConfigurationArgs(
    public val auditLog: Output<IngestionDestinationDestinationConfigurationAuditLogArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationArgs =
        com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationArgs.builder()
            .auditLog(auditLog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IngestionDestinationDestinationConfigurationArgs].
 */
@PulumiTagMarker
public class IngestionDestinationDestinationConfigurationArgsBuilder internal constructor() {
    private var auditLog: Output<IngestionDestinationDestinationConfigurationAuditLogArgs>? = null

    /**
     * @param value Contains information about an audit log processing configuration.
     */
    @JvmName("ulbqvnxpmelqovvb")
    public suspend fun auditLog(`value`: Output<IngestionDestinationDestinationConfigurationAuditLogArgs>) {
        this.auditLog = value
    }

    /**
     * @param value Contains information about an audit log processing configuration.
     */
    @JvmName("mhepbgkgxhlyqwkq")
    public suspend fun auditLog(`value`: IngestionDestinationDestinationConfigurationAuditLogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditLog = mapped
    }

    /**
     * @param argument Contains information about an audit log processing configuration.
     */
    @JvmName("vtpllwmmgrtjxdvq")
    public suspend fun auditLog(argument: suspend IngestionDestinationDestinationConfigurationAuditLogArgsBuilder.() -> Unit) {
        val toBeMapped = IngestionDestinationDestinationConfigurationAuditLogArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.auditLog = mapped
    }

    internal fun build(): IngestionDestinationDestinationConfigurationArgs =
        IngestionDestinationDestinationConfigurationArgs(
            auditLog = auditLog,
        )
}
