@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property destination Contains information about an audit log destination. Only one destination (Firehose Stream) or (S3 Bucket) can be specified.
 */
public data class IngestionDestinationDestinationConfigurationAuditLogArgs(
    public val destination: Output<IngestionDestinationDestinationConfigurationAuditLogDestinationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogArgs =
        com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IngestionDestinationDestinationConfigurationAuditLogArgs].
 */
@PulumiTagMarker
public class IngestionDestinationDestinationConfigurationAuditLogArgsBuilder internal constructor() {
    private var destination:
        Output<IngestionDestinationDestinationConfigurationAuditLogDestinationArgs>? = null

    /**
     * @param value Contains information about an audit log destination. Only one destination (Firehose Stream) or (S3 Bucket) can be specified.
     */
    @JvmName("tinrflkrsderaogp")
    public suspend fun destination(`value`: Output<IngestionDestinationDestinationConfigurationAuditLogDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Contains information about an audit log destination. Only one destination (Firehose Stream) or (S3 Bucket) can be specified.
     */
    @JvmName("eoplxjdnrttitcuu")
    public suspend fun destination(`value`: IngestionDestinationDestinationConfigurationAuditLogDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Contains information about an audit log destination. Only one destination (Firehose Stream) or (S3 Bucket) can be specified.
     */
    @JvmName("qdajctyggfsqikcv")
    public suspend fun destination(argument: suspend IngestionDestinationDestinationConfigurationAuditLogDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            IngestionDestinationDestinationConfigurationAuditLogDestinationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    internal fun build(): IngestionDestinationDestinationConfigurationAuditLogArgs =
        IngestionDestinationDestinationConfigurationAuditLogArgs(
            destination = destination,
        )
}
