@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property firehoseStream Contains information about an Amazon Data Firehose delivery stream.
 * @property s3Bucket Contains information about an Amazon S3 bucket.
 */
public data class IngestionDestinationDestinationConfigurationAuditLogDestinationArgs(
    public val firehoseStream: Output<IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStreamArgs>? =
        null,
    public val s3Bucket: Output<IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs =
        com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationArgs.builder()
            .firehoseStream(firehoseStream?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Bucket(s3Bucket?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IngestionDestinationDestinationConfigurationAuditLogDestinationArgs].
 */
@PulumiTagMarker
public class IngestionDestinationDestinationConfigurationAuditLogDestinationArgsBuilder internal constructor() {
    private var firehoseStream:
        Output<IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStreamArgs>? =
        null

    private var s3Bucket:
        Output<IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs>? = null

    /**
     * @param value Contains information about an Amazon Data Firehose delivery stream.
     */
    @JvmName("hpngtnhirprgwkon")
    public suspend fun firehoseStream(`value`: Output<IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStreamArgs>) {
        this.firehoseStream = value
    }

    /**
     * @param value Contains information about an Amazon S3 bucket.
     */
    @JvmName("knaacmvghueceakc")
    public suspend fun s3Bucket(`value`: Output<IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs>) {
        this.s3Bucket = value
    }

    /**
     * @param value Contains information about an Amazon Data Firehose delivery stream.
     */
    @JvmName("doahfajmgpfbqipv")
    public suspend fun firehoseStream(`value`: IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStreamArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firehoseStream = mapped
    }

    /**
     * @param argument Contains information about an Amazon Data Firehose delivery stream.
     */
    @JvmName("fdqmyyefccrytqhk")
    public suspend fun firehoseStream(argument: suspend IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStreamArgsBuilder.() -> Unit) {
        val toBeMapped =
            IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStreamArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.firehoseStream = mapped
    }

    /**
     * @param value Contains information about an Amazon S3 bucket.
     */
    @JvmName("palfqhaarfmbetjs")
    public suspend fun s3Bucket(`value`: IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param argument Contains information about an Amazon S3 bucket.
     */
    @JvmName("fbtcifnaqlqcueka")
    public suspend fun s3Bucket(argument: suspend IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgsBuilder.() -> Unit) {
        val toBeMapped =
            IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Bucket = mapped
    }

    internal fun build(): IngestionDestinationDestinationConfigurationAuditLogDestinationArgs =
        IngestionDestinationDestinationConfigurationAuditLogDestinationArgs(
            firehoseStream = firehoseStream,
            s3Bucket = s3Bucket,
        )
}
