@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName
 * @property prefix The object key to use.
 */
public data class IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs(
    public val bucketName: Output<String>,
    public val prefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs =
        com.pulumi.aws.appfabric.inputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs].
 */
@PulumiTagMarker
public class IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgsBuilder
internal constructor() {
    private var bucketName: Output<String>? = null

    private var prefix: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("agrwquwwquejepoh")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The object key to use.
     */
    @JvmName("rjwusbkgprnveqde")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value
     */
    @JvmName("apqrhrphdvjopvcs")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The object key to use.
     */
    @JvmName("xbpitckhfpvgwmwm")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs = IngestionDestinationDestinationConfigurationAuditLogDestinationS3BucketArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        prefix = prefix,
    )
}
