@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property auditLog Contains information about an audit log processing configuration.
 */
public data class IngestionDestinationProcessingConfigurationArgs(
    public val auditLog: Output<IngestionDestinationProcessingConfigurationAuditLogArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationArgs =
        com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationArgs.builder()
            .auditLog(auditLog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IngestionDestinationProcessingConfigurationArgs].
 */
@PulumiTagMarker
public class IngestionDestinationProcessingConfigurationArgsBuilder internal constructor() {
    private var auditLog: Output<IngestionDestinationProcessingConfigurationAuditLogArgs>? = null

    /**
     * @param value Contains information about an audit log processing configuration.
     */
    @JvmName("gyppggdtyrnnvtqq")
    public suspend fun auditLog(`value`: Output<IngestionDestinationProcessingConfigurationAuditLogArgs>) {
        this.auditLog = value
    }

    /**
     * @param value Contains information about an audit log processing configuration.
     */
    @JvmName("gfcaratsnbrgxgeg")
    public suspend fun auditLog(`value`: IngestionDestinationProcessingConfigurationAuditLogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditLog = mapped
    }

    /**
     * @param argument Contains information about an audit log processing configuration.
     */
    @JvmName("tkwylbaeetifejuu")
    public suspend fun auditLog(argument: suspend IngestionDestinationProcessingConfigurationAuditLogArgsBuilder.() -> Unit) {
        val toBeMapped = IngestionDestinationProcessingConfigurationAuditLogArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.auditLog = mapped
    }

    internal fun build(): IngestionDestinationProcessingConfigurationArgs =
        IngestionDestinationProcessingConfigurationArgs(
            auditLog = auditLog,
        )
}
