@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.inputs

import com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationAuditLogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property format The format in which the audit logs need to be formatted. Valid values: `json`, `parquet`.
 * @property schema The event schema in which the audit logs need to be formatted. Valid values: `ocsf`, `raw`.
 */
public data class IngestionDestinationProcessingConfigurationAuditLogArgs(
    public val format: Output<String>,
    public val schema: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationAuditLogArgs> {
    override fun toJava(): com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationAuditLogArgs =
        com.pulumi.aws.appfabric.inputs.IngestionDestinationProcessingConfigurationAuditLogArgs.builder()
            .format(format.applyValue({ args0 -> args0 }))
            .schema(schema.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngestionDestinationProcessingConfigurationAuditLogArgs].
 */
@PulumiTagMarker
public class IngestionDestinationProcessingConfigurationAuditLogArgsBuilder internal constructor() {
    private var format: Output<String>? = null

    private var schema: Output<String>? = null

    /**
     * @param value The format in which the audit logs need to be formatted. Valid values: `json`, `parquet`.
     */
    @JvmName("dwrylgwjewxpvney")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value The event schema in which the audit logs need to be formatted. Valid values: `ocsf`, `raw`.
     */
    @JvmName("fwomjdfnpolyuuod")
    public suspend fun schema(`value`: Output<String>) {
        this.schema = value
    }

    /**
     * @param value The format in which the audit logs need to be formatted. Valid values: `json`, `parquet`.
     */
    @JvmName("aphtgsacbbredxpn")
    public suspend fun format(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The event schema in which the audit logs need to be formatted. Valid values: `ocsf`, `raw`.
     */
    @JvmName("jejugmdkmglwmnvn")
    public suspend fun schema(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    internal fun build(): IngestionDestinationProcessingConfigurationAuditLogArgs =
        IngestionDestinationProcessingConfigurationAuditLogArgs(
            format = format ?: throw PulumiNullFieldException("format"),
            schema = schema ?: throw PulumiNullFieldException("schema"),
        )
}
