@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property code The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL)..
 * @property redirectUri The redirect URL that is specified in the AuthURL and the application client.
 */
public data class AppAuthorizationConnectionAuthRequest(
    public val code: String,
    public val redirectUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appfabric.outputs.AppAuthorizationConnectionAuthRequest): AppAuthorizationConnectionAuthRequest = AppAuthorizationConnectionAuthRequest(
            code = javaType.code(),
            redirectUri = javaType.redirectUri(),
        )
    }
}
