@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property apiKeyCredentials Contains API key credential information.
 * @property oauth2Credential Contains OAuth2 client credential information.
 */
public data class AppAuthorizationCredential(
    public val apiKeyCredentials: List<AppAuthorizationCredentialApiKeyCredential>? = null,
    public val oauth2Credential: AppAuthorizationCredentialOauth2Credential? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appfabric.outputs.AppAuthorizationCredential): AppAuthorizationCredential = AppAuthorizationCredential(
            apiKeyCredentials = javaType.apiKeyCredentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationCredentialApiKeyCredential.Companion.toKotlin(args0)
                })
            }),
            oauth2Credential = javaType.oauth2Credential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appfabric.kotlin.outputs.AppAuthorizationCredentialOauth2Credential.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
