@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property tenantDisplayName The display name of the tenant.
 * @property tenantIdentifier The ID of the application tenant.
 */
public data class AppAuthorizationTenant(
    public val tenantDisplayName: String,
    public val tenantIdentifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appfabric.outputs.AppAuthorizationTenant): AppAuthorizationTenant = AppAuthorizationTenant(
            tenantDisplayName = javaType.tenantDisplayName(),
            tenantIdentifier = javaType.tenantIdentifier(),
        )
    }
}
