@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property firehoseStream Contains information about an Amazon Data Firehose delivery stream.
 * @property s3Bucket Contains information about an Amazon S3 bucket.
 */
public data class IngestionDestinationDestinationConfigurationAuditLogDestination(
    public val firehoseStream: IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream? = null,
    public val s3Bucket: IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appfabric.outputs.IngestionDestinationDestinationConfigurationAuditLogDestination): IngestionDestinationDestinationConfigurationAuditLogDestination =
            IngestionDestinationDestinationConfigurationAuditLogDestination(
                firehoseStream = javaType.firehoseStream().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationDestinationConfigurationAuditLogDestinationFirehoseStream.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                s3Bucket = javaType.s3Bucket().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appfabric.kotlin.outputs.IngestionDestinationDestinationConfigurationAuditLogDestinationS3Bucket.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
