@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appfabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property format The format in which the audit logs need to be formatted. Valid values: `json`, `parquet`.
 * @property schema The event schema in which the audit logs need to be formatted. Valid values: `ocsf`, `raw`.
 */
public data class IngestionDestinationProcessingConfigurationAuditLog(
    public val format: String,
    public val schema: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appfabric.outputs.IngestionDestinationProcessingConfigurationAuditLog): IngestionDestinationProcessingConfigurationAuditLog =
            IngestionDestinationProcessingConfigurationAuditLog(
                format = javaType.format(),
                schema = javaType.schema(),
            )
    }
}
