@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin

import com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfig
import com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConnectorProfile].
 */
@PulumiTagMarker
public class ConnectorProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorProfileArgs = ConnectorProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorProfileArgsBuilder.() -> Unit) {
        val builder = ConnectorProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectorProfile {
        val builtJavaResource = com.pulumi.aws.appflow.ConnectorProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectorProfile(builtJavaResource)
    }
}

/**
 * Provides an AppFlow connector profile resource.
 * For information about AppFlow flows, see the [Amazon AppFlow API Reference](https://docs.aws.amazon.com/appflow/1.0/APIReference/Welcome.html).
 * For specific information about creating an AppFlow connector profile, see the
 * [CreateConnectorProfile](https://docs.aws.amazon.com/appflow/1.0/APIReference/API_CreateConnectorProfile.html) page in the Amazon AppFlow API Reference.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.iam.getPolicy({
 *     name: "AmazonRedshiftAllCommandsFullAccess",
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example_role",
 *     managedPolicyArns: [test&#46;arn],
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "ec2.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "example_bucket"});
 * const exampleCluster = new aws.redshift.Cluster("example", {
 *     clusterIdentifier: "example_cluster",
 *     databaseName: "example_db",
 *     masterUsername: "exampleuser",
 *     masterPassword: "examplePassword123!",
 *     nodeType: "dc1.large",
 *     clusterType: "single-node",
 * });
 * const exampleConnectorProfile = new aws.appflow.ConnectorProfile("example", {
 *     name: "example_profile",
 *     connectorType: "Redshift",
 *     connectionMode: "Public",
 *     connectorProfileConfig: {
 *         connectorProfileCredentials: {
 *             redshift: {
 *                 password: exampleCluster.masterPassword,
 *                 username: exampleCluster.masterUsername,
 *             },
 *         },
 *         connectorProfileProperties: {
 *             redshift: {
 *                 bucketName: exampleBucketV2.name,
 *                 databaseUrl: pulumi.interpolate`jdbc:redshift://${exampleCluster.endpoint}/${exampleCluster.databaseName}`,
 *                 roleArn: exampleRole.arn,
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.iam.get_policy(name="AmazonRedshiftAllCommandsFullAccess")
 * example_role = aws.iam.Role("example",
 *     name="example_role",
 *     managed_policy_arns=[test["arn"]],
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "ec2.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="example_bucket")
 * example_cluster = aws.redshift.Cluster("example",
 *     cluster_identifier="example_cluster",
 *     database_name="example_db",
 *     master_username="exampleuser",
 *     master_password="examplePassword123!",
 *     node_type="dc1.large",
 *     cluster_type="single-node")
 * example_connector_profile = aws.appflow.ConnectorProfile("example",
 *     name="example_profile",
 *     connector_type="Redshift",
 *     connection_mode="Public",
 *     connector_profile_config={
 *         "connector_profile_credentials": {
 *             "redshift": {
 *                 "password": example_cluster.master_password,
 *                 "username": example_cluster.master_username,
 *             },
 *         },
 *         "connector_profile_properties": {
 *             "redshift": {
 *                 "bucket_name": example_bucket_v2.name,
 *                 "database_url": pulumi.Output.all(example_cluster.endpoint, example_cluster.database_name).apply(lambda endpoint, database_name: f"jdbc:redshift://{endpoint}/{database_name}"),
 *                 "role_arn": example_role.arn,
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.Iam.GetPolicy.Invoke(new()
 *     {
 *         Name = "AmazonRedshiftAllCommandsFullAccess",
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example_role",
 *         ManagedPolicyArns = new[]
 *         {
 *             test.Arn,
 *         },
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "ec2.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example_bucket",
 *     });
 *     var exampleCluster = new Aws.RedShift.Cluster("example", new()
 *     {
 *         ClusterIdentifier = "example_cluster",
 *         DatabaseName = "example_db",
 *         MasterUsername = "exampleuser",
 *         MasterPassword = "examplePassword123!",
 *         NodeType = "dc1.large",
 *         ClusterType = "single-node",
 *     });
 *     var exampleConnectorProfile = new Aws.AppFlow.ConnectorProfile("example", new()
 *     {
 *         Name = "example_profile",
 *         ConnectorType = "Redshift",
 *         ConnectionMode = "Public",
 *         ConnectorProfileConfig = new Aws.AppFlow.Inputs.ConnectorProfileConnectorProfileConfigArgs
 *         {
 *             ConnectorProfileCredentials = new Aws.AppFlow.Inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs
 *             {
 *                 Redshift = new Aws.AppFlow.Inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs
 *                 {
 *                     Password = exampleCluster.MasterPassword,
 *                     Username = exampleCluster.MasterUsername,
 *                 },
 *             },
 *             ConnectorProfileProperties = new Aws.AppFlow.Inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs
 *             {
 *                 Redshift = new Aws.AppFlow.Inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs
 *                 {
 *                     BucketName = exampleBucketV2.Name,
 *                     DatabaseUrl = Output.Tuple(exampleCluster.Endpoint, exampleCluster.DatabaseName).Apply(values =>
 *                     {
 *                         var endpoint = values.Item1;
 *                         var databaseName = values.Item2;
 *                         return $"jdbc:redshift://{endpoint}/{databaseName}";
 *                     }),
 *                     RoleArn = exampleRole.Arn,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appflow"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshift"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iam.LookupPolicy(ctx, &iam.LookupPolicyArgs{
 * 			Name: pulumi.StringRef("AmazonRedshiftAllCommandsFullAccess"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "ec2.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name: pulumi.String("example_role"),
 * 			ManagedPolicyArns: pulumi.StringArray{
 * 				test.Arn,
 * 			},
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example_bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleCluster, err := redshift.NewCluster(ctx, "example", &redshift.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("example_cluster"),
 * 			DatabaseName:      pulumi.String("example_db"),
 * 			MasterUsername:    pulumi.String("exampleuser"),
 * 			MasterPassword:    pulumi.String("examplePassword123!"),
 * 			NodeType:          pulumi.String("dc1.large"),
 * 			ClusterType:       pulumi.String("single-node"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appflow.NewConnectorProfile(ctx, "example", &appflow.ConnectorProfileArgs{
 * 			Name:           pulumi.String("example_profile"),
 * 			ConnectorType:  pulumi.String("Redshift"),
 * 			ConnectionMode: pulumi.String("Public"),
 * 			ConnectorProfileConfig: &appflow.ConnectorProfileConnectorProfileConfigArgs{
 * 				ConnectorProfileCredentials: &appflow.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs{
 * 					Redshift: &appflow.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs{
 * 						Password: exampleCluster.MasterPassword,
 * 						Username: exampleCluster.MasterUsername,
 * 					},
 * 				},
 * 				ConnectorProfileProperties: &appflow.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs{
 * 					Redshift: &appflow.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs{
 * 						BucketName: exampleBucketV2.Name,
 * 						DatabaseUrl: pulumi.All(exampleCluster.Endpoint, exampleCluster.DatabaseName).ApplyT(func(_args []interface{}) (string, error) {
 * 							endpoint := _args[0].(string)
 * 							databaseName := _args[1].(string)
 * 							return fmt.Sprintf("jdbc:redshift://%v/%v", endpoint, databaseName), nil
 * 						}).(pulumi.StringOutput),
 * 						RoleArn: exampleRole.Arn,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.redshift.Cluster;
 * import com.pulumi.aws.redshift.ClusterArgs;
 * import com.pulumi.aws.appflow.ConnectorProfile;
 * import com.pulumi.aws.appflow.ConnectorProfileArgs;
 * import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigArgs;
 * import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs;
 * import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs;
 * import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs;
 * import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = IamFunctions.getPolicy(GetPolicyArgs.builder()
 *             .name("AmazonRedshiftAllCommandsFullAccess")
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example_role")
 *             .managedPolicyArns(test.arn())
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example_bucket")
 *             .build());
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .clusterIdentifier("example_cluster")
 *             .databaseName("example_db")
 *             .masterUsername("exampleuser")
 *             .masterPassword("examplePassword123!")
 *             .nodeType("dc1.large")
 *             .clusterType("single-node")
 *             .build());
 *         var exampleConnectorProfile = new ConnectorProfile("exampleConnectorProfile", ConnectorProfileArgs.builder()
 *             .name("example_profile")
 *             .connectorType("Redshift")
 *             .connectionMode("Public")
 *             .connectorProfileConfig(ConnectorProfileConnectorProfileConfigArgs.builder()
 *                 .connectorProfileCredentials(ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs.builder()
 *                     .redshift(ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs.builder()
 *                         .password(exampleCluster.masterPassword())
 *                         .username(exampleCluster.masterUsername())
 *                         .build())
 *                     .build())
 *                 .connectorProfileProperties(ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs.builder()
 *                     .redshift(ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs.builder()
 *                         .bucketName(exampleBucketV2.name())
 *                         .databaseUrl(Output.tuple(exampleCluster.endpoint(), exampleCluster.databaseName()).applyValue(values -> {
 *                             var endpoint = values.t1;
 *                             var databaseName = values.t2;
 *                             return String.format("jdbc:redshift://%s/%s", endpoint,databaseName);
 *                         }))
 *                         .roleArn(exampleRole.arn())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example_role
 *       managedPolicyArns:
 *         - ${test.arn}
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: ec2.amazonaws.com
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example_bucket
 *   exampleCluster:
 *     type: aws:redshift:Cluster
 *     name: example
 *     properties:
 *       clusterIdentifier: example_cluster
 *       databaseName: example_db
 *       masterUsername: exampleuser
 *       masterPassword: examplePassword123!
 *       nodeType: dc1.large
 *       clusterType: single-node
 *   exampleConnectorProfile:
 *     type: aws:appflow:ConnectorProfile
 *     name: example
 *     properties:
 *       name: example_profile
 *       connectorType: Redshift
 *       connectionMode: Public
 *       connectorProfileConfig:
 *         connectorProfileCredentials:
 *           redshift:
 *             password: ${exampleCluster.masterPassword}
 *             username: ${exampleCluster.masterUsername}
 *         connectorProfileProperties:
 *           redshift:
 *             bucketName: ${exampleBucketV2.name}
 *             databaseUrl: jdbc:redshift://${exampleCluster.endpoint}/${exampleCluster.databaseName}
 *             roleArn: ${exampleRole.arn}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicy
 *       Arguments:
 *         name: AmazonRedshiftAllCommandsFullAccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppFlow Connector Profile using the connector profile `arn`. For example:
 * ```sh
 * $ pulumi import aws:appflow/connectorProfile:ConnectorProfile profile arn:aws:appflow:us-west-2:123456789012:connectorprofile/example-profile
 * ```
 */
public class ConnectorProfile internal constructor(
    override val javaResource: com.pulumi.aws.appflow.ConnectorProfile,
) : KotlinCustomResource(javaResource, ConnectorProfileMapper) {
    /**
     * ARN of the connector profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Indicates the connection mode and specifies whether it is public or private. Private flows use AWS PrivateLink to route data over AWS infrastructure without exposing it to the public internet. One of: `Public`, `Private`.
     */
    public val connectionMode: Output<String>
        get() = javaResource.connectionMode().applyValue({ args0 -> args0 })

    /**
     * The label of the connector. The label is unique for each ConnectorRegistration in your AWS account. Only needed if calling for `CustomConnector` connector type.
     */
    public val connectorLabel: Output<String>?
        get() = javaResource.connectorLabel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defines the connector-specific configuration and credentials. See Connector Profile Config for more details.
     */
    public val connectorProfileConfig: Output<ConnectorProfileConnectorProfileConfig>
        get() = javaResource.connectorProfileConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The type of connector. One of: `Amplitude`, `CustomConnector`, `CustomerProfiles`, `Datadog`, `Dynatrace`, `EventBridge`, `Googleanalytics`, `Honeycode`, `Infornexus`, `LookoutMetrics`, `Marketo`, `Redshift`, `S3`, `Salesforce`, `SAPOData`, `Servicenow`, `Singular`, `Slack`, `Snowflake`, `Trendmicro`, `Upsolver`, `Veeva`, `Zendesk`.
     */
    public val connectorType: Output<String>
        get() = javaResource.connectorType().applyValue({ args0 -> args0 })

    /**
     * ARN of the connector profile credentials.
     */
    public val credentialsArn: Output<String>
        get() = javaResource.credentialsArn().applyValue({ args0 -> args0 })

    /**
     * ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    public val kmsArn: Output<String>
        get() = javaResource.kmsArn().applyValue({ args0 -> args0 })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ConnectorProfileMapper : ResourceMapper<ConnectorProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appflow.ConnectorProfile::class == javaResource::class

    override fun map(javaResource: Resource): ConnectorProfile = ConnectorProfile(
        javaResource as
            com.pulumi.aws.appflow.ConnectorProfile,
    )
}

/**
 * @see [ConnectorProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectorProfile].
 */
public suspend fun connectorProfile(
    name: String,
    block: suspend ConnectorProfileResourceBuilder.() -> Unit,
): ConnectorProfile {
    val builder = ConnectorProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectorProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectorProfile(name: String): ConnectorProfile {
    val builder = ConnectorProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
