@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property connectorProfileCredentials The connector-specific credentials required by each connector. See Connector Profile Credentials for more details.
 * @property connectorProfileProperties The connector-specific properties of the profile configuration. See Connector Profile Properties for more details.
 */
public data class ConnectorProfileConnectorProfileConfigArgs(
    public val connectorProfileCredentials: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs>,
    public val connectorProfileProperties: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs>,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigArgs.builder()
            .connectorProfileCredentials(
                connectorProfileCredentials.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .connectorProfileProperties(
                connectorProfileProperties.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigArgsBuilder internal constructor() {
    private var connectorProfileCredentials:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs>? = null

    private var connectorProfileProperties:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs>? = null

    /**
     * @param value The connector-specific credentials required by each connector. See Connector Profile Credentials for more details.
     */
    @JvmName("xfkhsflmbickxhxg")
    public suspend fun connectorProfileCredentials(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs>) {
        this.connectorProfileCredentials = value
    }

    /**
     * @param value The connector-specific properties of the profile configuration. See Connector Profile Properties for more details.
     */
    @JvmName("tnmyccvcqmxggaox")
    public suspend fun connectorProfileProperties(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs>) {
        this.connectorProfileProperties = value
    }

    /**
     * @param value The connector-specific credentials required by each connector. See Connector Profile Credentials for more details.
     */
    @JvmName("vnamiogwusppaagy")
    public suspend fun connectorProfileCredentials(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorProfileCredentials = mapped
    }

    /**
     * @param argument The connector-specific credentials required by each connector. See Connector Profile Credentials for more details.
     */
    @JvmName("xwsfcomlcjwwrwoa")
    public suspend fun connectorProfileCredentials(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.connectorProfileCredentials = mapped
    }

    /**
     * @param value The connector-specific properties of the profile configuration. See Connector Profile Properties for more details.
     */
    @JvmName("itheqbesjaewgoya")
    public suspend fun connectorProfileProperties(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorProfileProperties = mapped
    }

    /**
     * @param argument The connector-specific properties of the profile configuration. See Connector Profile Properties for more details.
     */
    @JvmName("vtmouryvrrphdmxl")
    public suspend fun connectorProfileProperties(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.connectorProfileProperties = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigArgs =
        ConnectorProfileConnectorProfileConfigArgs(
            connectorProfileCredentials = connectorProfileCredentials ?: throw
                PulumiNullFieldException("connectorProfileCredentials"),
            connectorProfileProperties = connectorProfileProperties ?: throw
                PulumiNullFieldException("connectorProfileProperties"),
        )
}
