@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amplitude The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
 * @property customConnector The connector-specific profile credentials required when using the custom connector. See Custom Connector Profile Credentials for more details.
 * @property datadog Connector-specific credentials required when using Datadog. See Datadog Connector Profile Credentials for more details.
 * @property dynatrace The connector-specific credentials required when using Dynatrace. See Dynatrace Connector Profile Credentials for more details.
 * @property googleAnalytics The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
 * @property honeycode The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
 * @property inforNexus The connector-specific credentials required when using Infor Nexus. See Infor Nexus Connector Profile Credentials for more details.
 * @property marketo Connector-specific credentials required when using Marketo. See Marketo Connector Profile Credentials for more details.
 * @property redshift Connector-specific credentials required when using Amazon Redshift. See Redshift Connector Profile Credentials for more details.
 * @property salesforce The connector-specific credentials required when using Salesforce. See Salesforce Connector Profile Credentials for more details.
 * @property sapoData The connector-specific credentials required when using SAPOData. See SAPOData Connector Profile Credentials for more details.
 * @property serviceNow The connector-specific credentials required when using ServiceNow. See ServiceNow Connector Profile Credentials for more details.
 * @property singular Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
 * @property slack Connector-specific credentials required when using Slack. See Slack Connector Profile Credentials for more details.
 * @property snowflake The connector-specific credentials required when using Snowflake. See Snowflake Connector Profile Credentials for more details.
 * @property trendmicro The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
 * @property veeva Connector-specific credentials required when using Veeva. See Veeva Connector Profile Credentials for more details.
 * @property zendesk Connector-specific credentials required when using Zendesk. See Zendesk Connector Profile Credentials for more details.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs(
    public val amplitude: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs>? =
        null,
    public val customConnector: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs>? =
        null,
    public val datadog: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs>? = null,
    public val dynatrace: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs>? =
        null,
    public val googleAnalytics: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalyticsArgs>? =
        null,
    public val honeycode: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs>? =
        null,
    public val inforNexus: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs>? =
        null,
    public val marketo: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs>? = null,
    public val redshift: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs>? = null,
    public val salesforce: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs>? =
        null,
    public val sapoData: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs>? = null,
    public val serviceNow: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs>? =
        null,
    public val singular: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs>? = null,
    public val slack: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackArgs>? = null,
    public val snowflake: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflakeArgs>? =
        null,
    public val trendmicro: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicroArgs>? =
        null,
    public val veeva: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeevaArgs>? = null,
    public val zendesk: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs.builder()
            .amplitude(amplitude?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customConnector(customConnector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .datadog(datadog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dynatrace(dynatrace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .googleAnalytics(googleAnalytics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .honeycode(honeycode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inforNexus(inforNexus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .marketo(marketo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redshift(redshift?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .salesforce(salesforce?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sapoData(sapoData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceNow(serviceNow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singular(singular?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .slack(slack?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snowflake(snowflake?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trendmicro(trendmicro?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .veeva(veeva?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zendesk(zendesk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgsBuilder internal constructor() {
    private var amplitude:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs>? = null

    private var customConnector:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs>? =
        null

    private var datadog:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs>? = null

    private var dynatrace:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs>? = null

    private var googleAnalytics:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalyticsArgs>? =
        null

    private var honeycode:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs>? = null

    private var inforNexus:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs>? =
        null

    private var marketo:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs>? = null

    private var redshift:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs>? = null

    private var salesforce:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs>? =
        null

    private var sapoData:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs>? = null

    private var serviceNow:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs>? =
        null

    private var singular:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs>? = null

    private var slack:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackArgs>? = null

    private var snowflake:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflakeArgs>? = null

    private var trendmicro:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicroArgs>? =
        null

    private var veeva:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeevaArgs>? = null

    private var zendesk:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs>? = null

    /**
     * @param value The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
     */
    @JvmName("dtwyoworyfuecngc")
    public suspend fun amplitude(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs>) {
        this.amplitude = value
    }

    /**
     * @param value The connector-specific profile credentials required when using the custom connector. See Custom Connector Profile Credentials for more details.
     */
    @JvmName("fdsqvivxeglesokf")
    public suspend fun customConnector(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs>) {
        this.customConnector = value
    }

    /**
     * @param value Connector-specific credentials required when using Datadog. See Datadog Connector Profile Credentials for more details.
     */
    @JvmName("gqfqywactseddupc")
    public suspend fun datadog(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs>) {
        this.datadog = value
    }

    /**
     * @param value The connector-specific credentials required when using Dynatrace. See Dynatrace Connector Profile Credentials for more details.
     */
    @JvmName("rbebqhjnlvjsowwg")
    public suspend fun dynatrace(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs>) {
        this.dynatrace = value
    }

    /**
     * @param value The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
     */
    @JvmName("alhpeyultskmyhkl")
    public suspend fun googleAnalytics(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalyticsArgs>) {
        this.googleAnalytics = value
    }

    /**
     * @param value The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
     */
    @JvmName("utawiemhoktjoiaw")
    public suspend fun honeycode(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs>) {
        this.honeycode = value
    }

    /**
     * @param value The connector-specific credentials required when using Infor Nexus. See Infor Nexus Connector Profile Credentials for more details.
     */
    @JvmName("rtbmelipjyalutbc")
    public suspend fun inforNexus(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs>) {
        this.inforNexus = value
    }

    /**
     * @param value Connector-specific credentials required when using Marketo. See Marketo Connector Profile Credentials for more details.
     */
    @JvmName("lfaipggsdieiencn")
    public suspend fun marketo(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs>) {
        this.marketo = value
    }

    /**
     * @param value Connector-specific credentials required when using Amazon Redshift. See Redshift Connector Profile Credentials for more details.
     */
    @JvmName("remjjrvavkcbhfyr")
    public suspend fun redshift(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs>) {
        this.redshift = value
    }

    /**
     * @param value The connector-specific credentials required when using Salesforce. See Salesforce Connector Profile Credentials for more details.
     */
    @JvmName("vaymgtnfjekksyvi")
    public suspend fun salesforce(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs>) {
        this.salesforce = value
    }

    /**
     * @param value The connector-specific credentials required when using SAPOData. See SAPOData Connector Profile Credentials for more details.
     */
    @JvmName("vqoiebtwikrpulln")
    public suspend fun sapoData(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs>) {
        this.sapoData = value
    }

    /**
     * @param value The connector-specific credentials required when using ServiceNow. See ServiceNow Connector Profile Credentials for more details.
     */
    @JvmName("wevgtkicccmjsmei")
    public suspend fun serviceNow(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs>) {
        this.serviceNow = value
    }

    /**
     * @param value Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
     */
    @JvmName("yaoysklpnfsjnror")
    public suspend fun singular(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs>) {
        this.singular = value
    }

    /**
     * @param value Connector-specific credentials required when using Slack. See Slack Connector Profile Credentials for more details.
     */
    @JvmName("dfxhgboujujyerah")
    public suspend fun slack(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackArgs>) {
        this.slack = value
    }

    /**
     * @param value The connector-specific credentials required when using Snowflake. See Snowflake Connector Profile Credentials for more details.
     */
    @JvmName("xhhrgoxstcdcfwpd")
    public suspend fun snowflake(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflakeArgs>) {
        this.snowflake = value
    }

    /**
     * @param value The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
     */
    @JvmName("txhbgxchymtqetbo")
    public suspend fun trendmicro(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicroArgs>) {
        this.trendmicro = value
    }

    /**
     * @param value Connector-specific credentials required when using Veeva. See Veeva Connector Profile Credentials for more details.
     */
    @JvmName("veakovnvlvosdpwe")
    public suspend fun veeva(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeevaArgs>) {
        this.veeva = value
    }

    /**
     * @param value Connector-specific credentials required when using Zendesk. See Zendesk Connector Profile Credentials for more details.
     */
    @JvmName("lyrjytlnjurbrney")
    public suspend fun zendesk(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs>) {
        this.zendesk = value
    }

    /**
     * @param value The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
     */
    @JvmName("diogvsqgfpxlxmla")
    public suspend fun amplitude(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amplitude = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
     */
    @JvmName("hcvxdlddqjtfcpmv")
    public suspend fun amplitude(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsAmplitudeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amplitude = mapped
    }

    /**
     * @param value The connector-specific profile credentials required when using the custom connector. See Custom Connector Profile Credentials for more details.
     */
    @JvmName("llgkbrqccevxjeuj")
    public suspend fun customConnector(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConnector = mapped
    }

    /**
     * @param argument The connector-specific profile credentials required when using the custom connector. See Custom Connector Profile Credentials for more details.
     */
    @JvmName("heweltlphubexbdt")
    public suspend fun customConnector(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customConnector = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Datadog. See Datadog Connector Profile Credentials for more details.
     */
    @JvmName("lgcdjvyadqccvdir")
    public suspend fun datadog(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datadog = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Datadog. See Datadog Connector Profile Credentials for more details.
     */
    @JvmName("qxvwufdvccrntfdr")
    public suspend fun datadog(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.datadog = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Dynatrace. See Dynatrace Connector Profile Credentials for more details.
     */
    @JvmName("ikxighhyvnqqssxd")
    public suspend fun dynatrace(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynatrace = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Dynatrace. See Dynatrace Connector Profile Credentials for more details.
     */
    @JvmName("frorqvsggqijdfeh")
    public suspend fun dynatrace(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDynatraceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dynatrace = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
     */
    @JvmName("vyrcvtxbhsuqrmld")
    public suspend fun googleAnalytics(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalyticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleAnalytics = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
     */
    @JvmName("vqrpuvfoyuhdpbrn")
    public suspend fun googleAnalytics(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalyticsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsGoogleAnalyticsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.googleAnalytics = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
     */
    @JvmName("aqbnsyidewoiophn")
    public suspend fun honeycode(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeycode = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
     */
    @JvmName("rwvedujgoylplfua")
    public suspend fun honeycode(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsHoneycodeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.honeycode = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Infor Nexus. See Infor Nexus Connector Profile Credentials for more details.
     */
    @JvmName("txhxycklwpgpqynk")
    public suspend fun inforNexus(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inforNexus = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Infor Nexus. See Infor Nexus Connector Profile Credentials for more details.
     */
    @JvmName("bfshdohssxvcclbo")
    public suspend fun inforNexus(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsInforNexusArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inforNexus = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Marketo. See Marketo Connector Profile Credentials for more details.
     */
    @JvmName("porkrgncjjpaiuvr")
    public suspend fun marketo(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketo = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Marketo. See Marketo Connector Profile Credentials for more details.
     */
    @JvmName("pogcqcbyskbwdbkc")
    public suspend fun marketo(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.marketo = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Amazon Redshift. See Redshift Connector Profile Credentials for more details.
     */
    @JvmName("xfxkwqbyrraqgcfy")
    public suspend fun redshift(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshift = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Amazon Redshift. See Redshift Connector Profile Credentials for more details.
     */
    @JvmName("etmecpwmmliuxfde")
    public suspend fun redshift(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsRedshiftArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.redshift = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Salesforce. See Salesforce Connector Profile Credentials for more details.
     */
    @JvmName("rrtjgnxwmrbysdfn")
    public suspend fun salesforce(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.salesforce = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Salesforce. See Salesforce Connector Profile Credentials for more details.
     */
    @JvmName("swhdwndsmxtmbuap")
    public suspend fun salesforce(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.salesforce = mapped
    }

    /**
     * @param value The connector-specific credentials required when using SAPOData. See SAPOData Connector Profile Credentials for more details.
     */
    @JvmName("nleydfvnipvqkyvo")
    public suspend fun sapoData(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapoData = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using SAPOData. See SAPOData Connector Profile Credentials for more details.
     */
    @JvmName("iyeswkspbnfelger")
    public suspend fun sapoData(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSapoDataArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sapoData = mapped
    }

    /**
     * @param value The connector-specific credentials required when using ServiceNow. See ServiceNow Connector Profile Credentials for more details.
     */
    @JvmName("siwbjfacruxwapwb")
    public suspend fun serviceNow(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNow = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using ServiceNow. See ServiceNow Connector Profile Credentials for more details.
     */
    @JvmName("orpkpllrqkbyebkr")
    public suspend fun serviceNow(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serviceNow = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
     */
    @JvmName("dmqddiqopeqroijk")
    public suspend fun singular(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singular = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
     */
    @JvmName("ankrfwyhensnontj")
    public suspend fun singular(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSingularArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singular = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Slack. See Slack Connector Profile Credentials for more details.
     */
    @JvmName("qjpgmoihhbjdqsxw")
    public suspend fun slack(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slack = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Slack. See Slack Connector Profile Credentials for more details.
     */
    @JvmName("kuqyowvhooigswbh")
    public suspend fun slack(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.slack = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Snowflake. See Snowflake Connector Profile Credentials for more details.
     */
    @JvmName("dnbemiebiduwhmfp")
    public suspend fun snowflake(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflakeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowflake = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Snowflake. See Snowflake Connector Profile Credentials for more details.
     */
    @JvmName("bvebceydmkwjlqha")
    public suspend fun snowflake(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflakeArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSnowflakeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.snowflake = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
     */
    @JvmName("jwklljakdbaucytk")
    public suspend fun trendmicro(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicroArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trendmicro = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
     */
    @JvmName("tpfepwstuyykqenv")
    public suspend fun trendmicro(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicroArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsTrendmicroArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.trendmicro = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Veeva. See Veeva Connector Profile Credentials for more details.
     */
    @JvmName("qckyutmpwfpmjnnh")
    public suspend fun veeva(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeevaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.veeva = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Veeva. See Veeva Connector Profile Credentials for more details.
     */
    @JvmName("ulbfkepkhnotfldp")
    public suspend fun veeva(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeevaArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsVeevaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.veeva = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Zendesk. See Zendesk Connector Profile Credentials for more details.
     */
    @JvmName("pefpuioaklqaegpq")
    public suspend fun zendesk(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zendesk = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Zendesk. See Zendesk Connector Profile Credentials for more details.
     */
    @JvmName("tghwijcuirgqakhn")
    public suspend fun zendesk(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsZendeskArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.zendesk = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsArgs(
            amplitude = amplitude,
            customConnector = customConnector,
            datadog = datadog,
            dynatrace = dynatrace,
            googleAnalytics = googleAnalytics,
            honeycode = honeycode,
            inforNexus = inforNexus,
            marketo = marketo,
            redshift = redshift,
            salesforce = salesforce,
            sapoData = sapoData,
            serviceNow = serviceNow,
            singular = singular,
            slack = slack,
            snowflake = snowflake,
            trendmicro = trendmicro,
            veeva = veeva,
            zendesk = zendesk,
        )
}
