@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property apiKey
 * @property authenticationType The authentication type that the custom connector uses for authenticating while creating a connector profile. One of: `APIKEY`, `BASIC`, `CUSTOM`, `OAUTH2`.
 * @property basic Basic credentials that are required for the authentication of the user.
 * @property custom If the connector uses the custom authentication mechanism, this holds the required credentials.
 * @property oauth2 OAuth 2.0 credentials required for the authentication of the user.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs(
    public val apiKey: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs>? =
        null,
    public val authenticationType: Output<String>,
    public val basic: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasicArgs>? =
        null,
    public val custom: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs>? =
        null,
    public val oauth2: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2Args>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs.builder()
            .apiKey(apiKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .basic(basic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .custom(custom?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .oauth2(oauth2?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgsBuilder
internal constructor() {
    private var apiKey:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs>? =
        null

    private var authenticationType: Output<String>? = null

    private var basic:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasicArgs>? =
        null

    private var custom:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs>? =
        null

    private var oauth2:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2Args>? =
        null

    /**
     * @param value
     */
    @JvmName("lsctggjqkmekrbtt")
    public suspend fun apiKey(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs>) {
        this.apiKey = value
    }

    /**
     * @param value The authentication type that the custom connector uses for authenticating while creating a connector profile. One of: `APIKEY`, `BASIC`, `CUSTOM`, `OAUTH2`.
     */
    @JvmName("iyifyxelfqxcewqk")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Basic credentials that are required for the authentication of the user.
     */
    @JvmName("wppfagrgpjerfuxm")
    public suspend fun basic(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasicArgs>) {
        this.basic = value
    }

    /**
     * @param value If the connector uses the custom authentication mechanism, this holds the required credentials.
     */
    @JvmName("ubliciglclhvstfr")
    public suspend fun custom(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs>) {
        this.custom = value
    }

    /**
     * @param value OAuth 2.0 credentials required for the authentication of the user.
     */
    @JvmName("vvvyvqkkjlvfujad")
    public suspend fun oauth2(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2Args>) {
        this.oauth2 = value
    }

    /**
     * @param value
     */
    @JvmName("hvcunqiemiwjtttc")
    public suspend fun apiKey(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param argument
     */
    @JvmName("srjilenilsouanad")
    public suspend fun apiKey(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorApiKeyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.apiKey = mapped
    }

    /**
     * @param value The authentication type that the custom connector uses for authenticating while creating a connector profile. One of: `APIKEY`, `BASIC`, `CUSTOM`, `OAUTH2`.
     */
    @JvmName("amusywbubsdoqavb")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Basic credentials that are required for the authentication of the user.
     */
    @JvmName("wkkpyirjwmlamvkm")
    public suspend fun basic(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasicArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.basic = mapped
    }

    /**
     * @param argument Basic credentials that are required for the authentication of the user.
     */
    @JvmName("igecoyjqmuuwgfkv")
    public suspend fun basic(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasicArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorBasicArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.basic = mapped
    }

    /**
     * @param value If the connector uses the custom authentication mechanism, this holds the required credentials.
     */
    @JvmName("qdmuqovkopucflyt")
    public suspend fun custom(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.custom = mapped
    }

    /**
     * @param argument If the connector uses the custom authentication mechanism, this holds the required credentials.
     */
    @JvmName("rjvgcbvmoqwjguon")
    public suspend fun custom(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorCustomArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.custom = mapped
    }

    /**
     * @param value OAuth 2.0 credentials required for the authentication of the user.
     */
    @JvmName("janhvoirmcsigvrx")
    public suspend fun oauth2(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauth2 = mapped
    }

    /**
     * @param argument OAuth 2.0 credentials required for the authentication of the user.
     */
    @JvmName("ljxqppwukvsyywyo")
    public suspend fun oauth2(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2ArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorOauth2ArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauth2 = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsCustomConnectorArgs(
            apiKey = apiKey,
            authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
            basic = basic,
            custom = custom,
            oauth2 = oauth2,
        )
}
