@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property apiKey
 * @property applicationKey Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs(
    public val apiKey: Output<String>,
    public val applicationKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs.builder()
            .apiKey(apiKey.applyValue({ args0 -> args0 }))
            .applicationKey(applicationKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgsBuilder
internal constructor() {
    private var apiKey: Output<String>? = null

    private var applicationKey: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ykajlfbiixkjqcye")
    public suspend fun apiKey(`value`: Output<String>) {
        this.apiKey = value
    }

    /**
     * @param value Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
     */
    @JvmName("ivyjeofboxsmpjqu")
    public suspend fun applicationKey(`value`: Output<String>) {
        this.applicationKey = value
    }

    /**
     * @param value
     */
    @JvmName("jgswslphvrykvjhb")
    public suspend fun apiKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param value Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
     */
    @JvmName("fvajetvjjfhusyll")
    public suspend fun applicationKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationKey = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs = ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsDatadogArgs(
        apiKey = apiKey ?: throw PulumiNullFieldException("apiKey"),
        applicationKey = applicationKey ?: throw PulumiNullFieldException("applicationKey"),
    )
}
