@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken
 * @property clientId
 * @property clientSecret
 * @property oauthRequest
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs(
    public val accessToken: Output<String>? = null,
    public val clientId: Output<String>,
    public val clientSecret: Output<String>,
    public val oauthRequest: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret.applyValue({ args0 -> args0 }))
            .oauthRequest(oauthRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgsBuilder
internal constructor() {
    private var accessToken: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var oauthRequest:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs>? =
        null

    /**
     * @param value
     */
    @JvmName("ctcviubqbwsyiflp")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value
     */
    @JvmName("xtakptqnooovwfog")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value
     */
    @JvmName("ljragfpbbwohtkhk")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value
     */
    @JvmName("sstwiosiqbsptknl")
    public suspend fun oauthRequest(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs>) {
        this.oauthRequest = value
    }

    /**
     * @param value
     */
    @JvmName("bjovvkpxvjupvmtg")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value
     */
    @JvmName("fjylbamhylkbbxkx")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value
     */
    @JvmName("obrnaggblylbsdiw")
    public suspend fun clientSecret(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value
     */
    @JvmName("rtbxgloilrryfioc")
    public suspend fun oauthRequest(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthRequest = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fwjjquvkmrojoqhj")
    public suspend fun oauthRequest(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoOauthRequestArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthRequest = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs = ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsMarketoArgs(
        accessToken = accessToken,
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        clientSecret = clientSecret ?: throw PulumiNullFieldException("clientSecret"),
        oauthRequest = oauthRequest,
    )
}
