@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessToken
 * @property clientCredentialsArn The secret manager ARN, which contains the client ID and client secret of the connected app.
 * @property jwtToken A JSON web token (JWT) that authorizes access to Salesforce records.
 * @property oauth2GrantType
 * @property oauthRequest
 * @property refreshToken
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs(
    public val accessToken: Output<String>? = null,
    public val clientCredentialsArn: Output<String>? = null,
    public val jwtToken: Output<String>? = null,
    public val oauth2GrantType: Output<String>? = null,
    public val oauthRequest: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs>? =
        null,
    public val refreshToken: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs.builder()
            .accessToken(accessToken?.applyValue({ args0 -> args0 }))
            .clientCredentialsArn(clientCredentialsArn?.applyValue({ args0 -> args0 }))
            .jwtToken(jwtToken?.applyValue({ args0 -> args0 }))
            .oauth2GrantType(oauth2GrantType?.applyValue({ args0 -> args0 }))
            .oauthRequest(oauthRequest?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgsBuilder
internal constructor() {
    private var accessToken: Output<String>? = null

    private var clientCredentialsArn: Output<String>? = null

    private var jwtToken: Output<String>? = null

    private var oauth2GrantType: Output<String>? = null

    private var oauthRequest:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs>? =
        null

    private var refreshToken: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("uyestpkihnqnkapq")
    public suspend fun accessToken(`value`: Output<String>) {
        this.accessToken = value
    }

    /**
     * @param value The secret manager ARN, which contains the client ID and client secret of the connected app.
     */
    @JvmName("lbhexlwrpuhersyr")
    public suspend fun clientCredentialsArn(`value`: Output<String>) {
        this.clientCredentialsArn = value
    }

    /**
     * @param value A JSON web token (JWT) that authorizes access to Salesforce records.
     */
    @JvmName("wwnmjynvivfliiqk")
    public suspend fun jwtToken(`value`: Output<String>) {
        this.jwtToken = value
    }

    /**
     * @param value
     */
    @JvmName("wkedhbunhagloede")
    public suspend fun oauth2GrantType(`value`: Output<String>) {
        this.oauth2GrantType = value
    }

    /**
     * @param value
     */
    @JvmName("amukyhlaqarelhum")
    public suspend fun oauthRequest(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs>) {
        this.oauthRequest = value
    }

    /**
     * @param value
     */
    @JvmName("iamlubfqhlyharej")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value
     */
    @JvmName("vladygilimkpycoe")
    public suspend fun accessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value The secret manager ARN, which contains the client ID and client secret of the connected app.
     */
    @JvmName("viumglwrstposchn")
    public suspend fun clientCredentialsArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientCredentialsArn = mapped
    }

    /**
     * @param value A JSON web token (JWT) that authorizes access to Salesforce records.
     */
    @JvmName("fxyvxdciwoljsppv")
    public suspend fun jwtToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jwtToken = mapped
    }

    /**
     * @param value
     */
    @JvmName("vbessamwrcqvoecn")
    public suspend fun oauth2GrantType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauth2GrantType = mapped
    }

    /**
     * @param value
     */
    @JvmName("kyrdxrntejhobvrh")
    public suspend fun oauthRequest(`value`: ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthRequest = mapped
    }

    /**
     * @param argument
     */
    @JvmName("llfmxftsgrsarcau")
    public suspend fun oauthRequest(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceOauthRequestArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthRequest = mapped
    }

    /**
     * @param value
     */
    @JvmName("roajjwksfoxqbuku")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSalesforceArgs(
            accessToken = accessToken,
            clientCredentialsArn = clientCredentialsArn,
            jwtToken = jwtToken,
            oauth2GrantType = oauth2GrantType,
            oauthRequest = oauthRequest,
            refreshToken = refreshToken,
        )
}
