@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password
 * @property username
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs(
    public val password: Output<String>,
    public val username: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs.builder()
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgsBuilder
internal constructor() {
    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("iefagofgtnnkwkxy")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("wkhqnsgwbhmfenah")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value
     */
    @JvmName("ewmqcjfkvywqckyf")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("xcowrywkdiexnmxg")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsServiceNowArgs(
            password = password ?: throw PulumiNullFieldException("password"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
