@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authCode The code provided by the connector when it has been authenticated via the connected app.
 * @property redirectUri The URL to which the authentication server redirects the browser after authorization has been granted.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs(
    public val authCode: Output<String>? = null,
    public val redirectUri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs.builder()
            .authCode(authCode?.applyValue({ args0 -> args0 }))
            .redirectUri(redirectUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgsBuilder
internal constructor() {
    private var authCode: Output<String>? = null

    private var redirectUri: Output<String>? = null

    /**
     * @param value The code provided by the connector when it has been authenticated via the connected app.
     */
    @JvmName("fmtsrfgmgbimnqqw")
    public suspend fun authCode(`value`: Output<String>) {
        this.authCode = value
    }

    /**
     * @param value The URL to which the authentication server redirects the browser after authorization has been granted.
     */
    @JvmName("mmohyhrywlujgxrx")
    public suspend fun redirectUri(`value`: Output<String>) {
        this.redirectUri = value
    }

    /**
     * @param value The code provided by the connector when it has been authenticated via the connected app.
     */
    @JvmName("pwuxnljxljpxknyc")
    public suspend fun authCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authCode = mapped
    }

    /**
     * @param value The URL to which the authentication server redirects the browser after authorization has been granted.
     */
    @JvmName("meijxpvrdlqcwrhg")
    public suspend fun redirectUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUri = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfileCredentialsSlackOauthRequestArgs(
            authCode = authCode,
            redirectUri = redirectUri,
        )
}
