@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amplitude The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
 * @property customConnector The connector-specific profile properties required when using the custom connector. See Custom Connector Profile Properties for more details.
 * @property datadog Connector-specific properties required when using Datadog. See Generic Connector Profile Properties for more details.
 * @property dynatrace The connector-specific properties required when using Dynatrace. See Generic Connector Profile Properties for more details.
 * @property googleAnalytics The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
 * @property honeycode The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
 * @property inforNexus The connector-specific properties required when using Infor Nexus. See Generic Connector Profile Properties for more details.
 * @property marketo Connector-specific properties required when using Marketo. See Generic Connector Profile Properties for more details.
 * @property redshift Connector-specific properties required when using Amazon Redshift. See Redshift Connector Profile Properties for more details.
 * @property salesforce The connector-specific properties required when using Salesforce. See Salesforce Connector Profile Properties for more details.
 * @property sapoData The connector-specific properties required when using SAPOData. See SAPOData Connector Profile Properties for more details.
 * @property serviceNow The connector-specific properties required when using ServiceNow. See Generic Connector Profile Properties for more details.
 * @property singular Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
 * @property slack Connector-specific properties required when using Slack. See Generic Connector Profile Properties for more details.
 * @property snowflake The connector-specific properties required when using Snowflake. See Snowflake Connector Profile Properties for more details.
 * @property trendmicro The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
 * @property veeva Connector-specific properties required when using Veeva. See Generic Connector Profile Properties for more details.
 * @property zendesk Connector-specific properties required when using Zendesk. See Generic Connector Profile Properties for more details.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs(
    public val amplitude: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitudeArgs>? = null,
    public val customConnector: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs>? =
        null,
    public val datadog: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadogArgs>? = null,
    public val dynatrace: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatraceArgs>? = null,
    public val googleAnalytics: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalyticsArgs>? =
        null,
    public val honeycode: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycodeArgs>? = null,
    public val inforNexus: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexusArgs>? =
        null,
    public val marketo: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs>? = null,
    public val redshift: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs>? = null,
    public val salesforce: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs>? =
        null,
    public val sapoData: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs>? = null,
    public val serviceNow: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNowArgs>? =
        null,
    public val singular: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingularArgs>? = null,
    public val slack: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs>? = null,
    public val snowflake: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs>? = null,
    public val trendmicro: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicroArgs>? =
        null,
    public val veeva: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeevaArgs>? = null,
    public val zendesk: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs.builder()
            .amplitude(amplitude?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customConnector(customConnector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .datadog(datadog?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dynatrace(dynatrace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .googleAnalytics(googleAnalytics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .honeycode(honeycode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inforNexus(inforNexus?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .marketo(marketo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redshift(redshift?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .salesforce(salesforce?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sapoData(sapoData?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceNow(serviceNow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singular(singular?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .slack(slack?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .snowflake(snowflake?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trendmicro(trendmicro?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .veeva(veeva?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zendesk(zendesk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgsBuilder internal constructor() {
    private var amplitude:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitudeArgs>? = null

    private var customConnector:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs>? =
        null

    private var datadog:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadogArgs>? = null

    private var dynatrace:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatraceArgs>? = null

    private var googleAnalytics:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalyticsArgs>? =
        null

    private var honeycode:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycodeArgs>? = null

    private var inforNexus:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexusArgs>? = null

    private var marketo:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs>? = null

    private var redshift:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs>? = null

    private var salesforce:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs>? = null

    private var sapoData:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs>? = null

    private var serviceNow:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNowArgs>? = null

    private var singular:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingularArgs>? = null

    private var slack:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs>? = null

    private var snowflake:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs>? = null

    private var trendmicro:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicroArgs>? = null

    private var veeva:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeevaArgs>? = null

    private var zendesk:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs>? = null

    /**
     * @param value The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
     */
    @JvmName("akppntbbdbinmrtl")
    public suspend fun amplitude(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitudeArgs>) {
        this.amplitude = value
    }

    /**
     * @param value The connector-specific profile properties required when using the custom connector. See Custom Connector Profile Properties for more details.
     */
    @JvmName("myyxpsgkhqqfrkgo")
    public suspend fun customConnector(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs>) {
        this.customConnector = value
    }

    /**
     * @param value Connector-specific properties required when using Datadog. See Generic Connector Profile Properties for more details.
     */
    @JvmName("esxssetygcvrpche")
    public suspend fun datadog(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadogArgs>) {
        this.datadog = value
    }

    /**
     * @param value The connector-specific properties required when using Dynatrace. See Generic Connector Profile Properties for more details.
     */
    @JvmName("bjojulufyirtodij")
    public suspend fun dynatrace(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatraceArgs>) {
        this.dynatrace = value
    }

    /**
     * @param value The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
     */
    @JvmName("ywtwdrwykqcxrquq")
    public suspend fun googleAnalytics(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalyticsArgs>) {
        this.googleAnalytics = value
    }

    /**
     * @param value The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
     */
    @JvmName("proisrmjulmdqkfa")
    public suspend fun honeycode(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycodeArgs>) {
        this.honeycode = value
    }

    /**
     * @param value The connector-specific properties required when using Infor Nexus. See Generic Connector Profile Properties for more details.
     */
    @JvmName("gkmrwpujurextbls")
    public suspend fun inforNexus(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexusArgs>) {
        this.inforNexus = value
    }

    /**
     * @param value Connector-specific properties required when using Marketo. See Generic Connector Profile Properties for more details.
     */
    @JvmName("qersuutxyoomitqy")
    public suspend fun marketo(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs>) {
        this.marketo = value
    }

    /**
     * @param value Connector-specific properties required when using Amazon Redshift. See Redshift Connector Profile Properties for more details.
     */
    @JvmName("qpvdyorkbqmxwjds")
    public suspend fun redshift(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs>) {
        this.redshift = value
    }

    /**
     * @param value The connector-specific properties required when using Salesforce. See Salesforce Connector Profile Properties for more details.
     */
    @JvmName("myomdfuukcavnban")
    public suspend fun salesforce(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs>) {
        this.salesforce = value
    }

    /**
     * @param value The connector-specific properties required when using SAPOData. See SAPOData Connector Profile Properties for more details.
     */
    @JvmName("jkoqokuqsxqrenyg")
    public suspend fun sapoData(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs>) {
        this.sapoData = value
    }

    /**
     * @param value The connector-specific properties required when using ServiceNow. See Generic Connector Profile Properties for more details.
     */
    @JvmName("wmorvquqndnubrmy")
    public suspend fun serviceNow(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNowArgs>) {
        this.serviceNow = value
    }

    /**
     * @param value Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
     */
    @JvmName("qafcxydildpbcdpk")
    public suspend fun singular(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingularArgs>) {
        this.singular = value
    }

    /**
     * @param value Connector-specific properties required when using Slack. See Generic Connector Profile Properties for more details.
     */
    @JvmName("vdnbclqhpdjvppmt")
    public suspend fun slack(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs>) {
        this.slack = value
    }

    /**
     * @param value The connector-specific properties required when using Snowflake. See Snowflake Connector Profile Properties for more details.
     */
    @JvmName("tywxgonokrmdpfvp")
    public suspend fun snowflake(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs>) {
        this.snowflake = value
    }

    /**
     * @param value The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
     */
    @JvmName("agnypqqfgfkdfrjr")
    public suspend fun trendmicro(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicroArgs>) {
        this.trendmicro = value
    }

    /**
     * @param value Connector-specific properties required when using Veeva. See Generic Connector Profile Properties for more details.
     */
    @JvmName("jovxkbfgifpfhmwn")
    public suspend fun veeva(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeevaArgs>) {
        this.veeva = value
    }

    /**
     * @param value Connector-specific properties required when using Zendesk. See Generic Connector Profile Properties for more details.
     */
    @JvmName("kpqtjkaheftdjdii")
    public suspend fun zendesk(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs>) {
        this.zendesk = value
    }

    /**
     * @param value The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
     */
    @JvmName("smrhkfanxggckirw")
    public suspend fun amplitude(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitudeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amplitude = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
     */
    @JvmName("juidiaurvfslkarj")
    public suspend fun amplitude(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitudeArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitudeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amplitude = mapped
    }

    /**
     * @param value The connector-specific profile properties required when using the custom connector. See Custom Connector Profile Properties for more details.
     */
    @JvmName("dkkrhnuhxxgxptlw")
    public suspend fun customConnector(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customConnector = mapped
    }

    /**
     * @param argument The connector-specific profile properties required when using the custom connector. See Custom Connector Profile Properties for more details.
     */
    @JvmName("owlpbrqiggbjtowu")
    public suspend fun customConnector(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customConnector = mapped
    }

    /**
     * @param value Connector-specific properties required when using Datadog. See Generic Connector Profile Properties for more details.
     */
    @JvmName("xricmruviotnqgxx")
    public suspend fun datadog(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datadog = mapped
    }

    /**
     * @param argument Connector-specific properties required when using Datadog. See Generic Connector Profile Properties for more details.
     */
    @JvmName("mibqykokhryfblmt")
    public suspend fun datadog(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadogArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadogArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.datadog = mapped
    }

    /**
     * @param value The connector-specific properties required when using Dynatrace. See Generic Connector Profile Properties for more details.
     */
    @JvmName("fcjpiwuyljsuskol")
    public suspend fun dynatrace(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatraceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dynatrace = mapped
    }

    /**
     * @param argument The connector-specific properties required when using Dynatrace. See Generic Connector Profile Properties for more details.
     */
    @JvmName("kcrlbgpceeachpvi")
    public suspend fun dynatrace(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatraceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatraceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dynatrace = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
     */
    @JvmName("hxbqhfqqscnhajqm")
    public suspend fun googleAnalytics(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalyticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.googleAnalytics = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
     */
    @JvmName("lwypwiabkyehtdst")
    public suspend fun googleAnalytics(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalyticsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalyticsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.googleAnalytics = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
     */
    @JvmName("eisjmqhjmlxqfxmc")
    public suspend fun honeycode(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.honeycode = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
     */
    @JvmName("pnncysaleaaaaymd")
    public suspend fun honeycode(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycodeArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycodeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.honeycode = mapped
    }

    /**
     * @param value The connector-specific properties required when using Infor Nexus. See Generic Connector Profile Properties for more details.
     */
    @JvmName("kpmqdnkjqakgxajf")
    public suspend fun inforNexus(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inforNexus = mapped
    }

    /**
     * @param argument The connector-specific properties required when using Infor Nexus. See Generic Connector Profile Properties for more details.
     */
    @JvmName("foaxfqneitplrnqc")
    public suspend fun inforNexus(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexusArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexusArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.inforNexus = mapped
    }

    /**
     * @param value Connector-specific properties required when using Marketo. See Generic Connector Profile Properties for more details.
     */
    @JvmName("gpsjfaxuoiaenbca")
    public suspend fun marketo(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketo = mapped
    }

    /**
     * @param argument Connector-specific properties required when using Marketo. See Generic Connector Profile Properties for more details.
     */
    @JvmName("rducvvwcheusytvq")
    public suspend fun marketo(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketoArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.marketo = mapped
    }

    /**
     * @param value Connector-specific properties required when using Amazon Redshift. See Redshift Connector Profile Properties for more details.
     */
    @JvmName("grvbfqptabbpsfqc")
    public suspend fun redshift(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshift = mapped
    }

    /**
     * @param argument Connector-specific properties required when using Amazon Redshift. See Redshift Connector Profile Properties for more details.
     */
    @JvmName("eairmuivbrpvpufs")
    public suspend fun redshift(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.redshift = mapped
    }

    /**
     * @param value The connector-specific properties required when using Salesforce. See Salesforce Connector Profile Properties for more details.
     */
    @JvmName("qcbgfaxnxemkxaik")
    public suspend fun salesforce(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.salesforce = mapped
    }

    /**
     * @param argument The connector-specific properties required when using Salesforce. See Salesforce Connector Profile Properties for more details.
     */
    @JvmName("usefapepgqqqajxg")
    public suspend fun salesforce(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.salesforce = mapped
    }

    /**
     * @param value The connector-specific properties required when using SAPOData. See SAPOData Connector Profile Properties for more details.
     */
    @JvmName("jlnshjmpbrygejrk")
    public suspend fun sapoData(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sapoData = mapped
    }

    /**
     * @param argument The connector-specific properties required when using SAPOData. See SAPOData Connector Profile Properties for more details.
     */
    @JvmName("pugyyybkhklrotrk")
    public suspend fun sapoData(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sapoData = mapped
    }

    /**
     * @param value The connector-specific properties required when using ServiceNow. See Generic Connector Profile Properties for more details.
     */
    @JvmName("wyytkdvrifsjmfgh")
    public suspend fun serviceNow(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceNow = mapped
    }

    /**
     * @param argument The connector-specific properties required when using ServiceNow. See Generic Connector Profile Properties for more details.
     */
    @JvmName("dbspgkhxxbgfdyei")
    public suspend fun serviceNow(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNowArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNowArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serviceNow = mapped
    }

    /**
     * @param value Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
     */
    @JvmName("mjqnwodhqnjidlnu")
    public suspend fun singular(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingularArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singular = mapped
    }

    /**
     * @param argument Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
     */
    @JvmName("vgeioaxueylyffxr")
    public suspend fun singular(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingularArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingularArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singular = mapped
    }

    /**
     * @param value Connector-specific properties required when using Slack. See Generic Connector Profile Properties for more details.
     */
    @JvmName("qckbdxcqanaltrym")
    public suspend fun slack(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slack = mapped
    }

    /**
     * @param argument Connector-specific properties required when using Slack. See Generic Connector Profile Properties for more details.
     */
    @JvmName("pgexvdcblwghyggj")
    public suspend fun slack(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlackArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.slack = mapped
    }

    /**
     * @param value The connector-specific properties required when using Snowflake. See Snowflake Connector Profile Properties for more details.
     */
    @JvmName("kwroafjqtbpxfsgd")
    public suspend fun snowflake(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowflake = mapped
    }

    /**
     * @param argument The connector-specific properties required when using Snowflake. See Snowflake Connector Profile Properties for more details.
     */
    @JvmName("lnfsqkrqtdaicwmd")
    public suspend fun snowflake(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflakeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.snowflake = mapped
    }

    /**
     * @param value The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
     */
    @JvmName("yofeionrwktslrkc")
    public suspend fun trendmicro(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicroArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trendmicro = mapped
    }

    /**
     * @param argument The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
     */
    @JvmName("hmbolylwgypgrxda")
    public suspend fun trendmicro(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicroArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicroArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.trendmicro = mapped
    }

    /**
     * @param value Connector-specific properties required when using Veeva. See Generic Connector Profile Properties for more details.
     */
    @JvmName("pcdtkovhyqixpmcb")
    public suspend fun veeva(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeevaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.veeva = mapped
    }

    /**
     * @param argument Connector-specific properties required when using Veeva. See Generic Connector Profile Properties for more details.
     */
    @JvmName("kxbwlikbphiulkag")
    public suspend fun veeva(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeevaArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeevaArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.veeva = mapped
    }

    /**
     * @param value Connector-specific properties required when using Zendesk. See Generic Connector Profile Properties for more details.
     */
    @JvmName("avkfsantxvhcqotq")
    public suspend fun zendesk(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zendesk = mapped
    }

    /**
     * @param argument Connector-specific properties required when using Zendesk. See Generic Connector Profile Properties for more details.
     */
    @JvmName("fjueqlwfikjuuddx")
    public suspend fun zendesk(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendeskArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.zendesk = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesArgs(
            amplitude = amplitude,
            customConnector = customConnector,
            datadog = datadog,
            dynatrace = dynatrace,
            googleAnalytics = googleAnalytics,
            honeycode = honeycode,
            inforNexus = inforNexus,
            marketo = marketo,
            redshift = redshift,
            salesforce = salesforce,
            sapoData = sapoData,
            serviceNow = serviceNow,
            singular = singular,
            slack = slack,
            snowflake = snowflake,
            trendmicro = trendmicro,
            veeva = veeva,
            zendesk = zendesk,
        )
}
