@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property oauth2GrantType
 * @property tokenUrl
 * @property tokenUrlCustomProperties Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs(
    public val oauth2GrantType: Output<String>,
    public val tokenUrl: Output<String>,
    public val tokenUrlCustomProperties: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs.builder()
            .oauth2GrantType(oauth2GrantType.applyValue({ args0 -> args0 }))
            .tokenUrl(tokenUrl.applyValue({ args0 -> args0 }))
            .tokenUrlCustomProperties(
                tokenUrlCustomProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs].
 */
@PulumiTagMarker
public class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgsBuilder
internal constructor() {
    private var oauth2GrantType: Output<String>? = null

    private var tokenUrl: Output<String>? = null

    private var tokenUrlCustomProperties: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("kmdgqrleaytigoob")
    public suspend fun oauth2GrantType(`value`: Output<String>) {
        this.oauth2GrantType = value
    }

    /**
     * @param value
     */
    @JvmName("acsrjcqdaehadite")
    public suspend fun tokenUrl(`value`: Output<String>) {
        this.tokenUrl = value
    }

    /**
     * @param value Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.
     */
    @JvmName("dmqsqbumhtebtwps")
    public suspend fun tokenUrlCustomProperties(`value`: Output<Map<String, String>>) {
        this.tokenUrlCustomProperties = value
    }

    /**
     * @param value
     */
    @JvmName("ygskhflodsebdtrr")
    public suspend fun oauth2GrantType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.oauth2GrantType = mapped
    }

    /**
     * @param value
     */
    @JvmName("fwcpekobsxatgsyq")
    public suspend fun tokenUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenUrl = mapped
    }

    /**
     * @param value Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.
     */
    @JvmName("gsipkejjeilhvaib")
    public suspend fun tokenUrlCustomProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tokenUrlCustomProperties = mapped
    }

    /**
     * @param values Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.
     */
    @JvmName("juqdrgulesjrsbam")
    public fun tokenUrlCustomProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenUrlCustomProperties = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2PropertiesArgs(
            oauth2GrantType = oauth2GrantType ?: throw PulumiNullFieldException("oauth2GrantType"),
            tokenUrl = tokenUrl ?: throw PulumiNullFieldException("tokenUrl"),
            tokenUrlCustomProperties = tokenUrlCustomProperties,
        )
}
