@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName
 * @property bucketPrefix
 * @property clusterIdentifier The unique ID that's assigned to an Amazon Redshift cluster.
 * @property dataApiRoleArn ARN of the IAM role that permits AppFlow to access the database through Data API.
 * @property databaseName The name of an Amazon Redshift database.
 * @property databaseUrl The JDBC URL of the Amazon Redshift cluster.
 * @property roleArn ARN of the IAM role.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val clusterIdentifier: Output<String>? = null,
    public val dataApiRoleArn: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val databaseUrl: Output<String>? = null,
    public val roleArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .clusterIdentifier(clusterIdentifier?.applyValue({ args0 -> args0 }))
            .dataApiRoleArn(dataApiRoleArn?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .databaseUrl(databaseUrl?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgsBuilder
internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var clusterIdentifier: Output<String>? = null

    private var dataApiRoleArn: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var databaseUrl: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("yilebxhqfarvkufy")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value
     */
    @JvmName("pntpvakhhmycoqid")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value The unique ID that's assigned to an Amazon Redshift cluster.
     */
    @JvmName("tnloflclbfljbnkn")
    public suspend fun clusterIdentifier(`value`: Output<String>) {
        this.clusterIdentifier = value
    }

    /**
     * @param value ARN of the IAM role that permits AppFlow to access the database through Data API.
     */
    @JvmName("cblluudjqwrdwmpc")
    public suspend fun dataApiRoleArn(`value`: Output<String>) {
        this.dataApiRoleArn = value
    }

    /**
     * @param value The name of an Amazon Redshift database.
     */
    @JvmName("prdkxhwxmlbrjniw")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The JDBC URL of the Amazon Redshift cluster.
     */
    @JvmName("dumhhbugqmsckycm")
    public suspend fun databaseUrl(`value`: Output<String>) {
        this.databaseUrl = value
    }

    /**
     * @param value ARN of the IAM role.
     */
    @JvmName("bdovgmrnkupatbty")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value
     */
    @JvmName("vxappyjkjamqppbt")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value
     */
    @JvmName("jjjrigrhcaoxgcpa")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value The unique ID that's assigned to an Amazon Redshift cluster.
     */
    @JvmName("efmcxmlpytnhgran")
    public suspend fun clusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value ARN of the IAM role that permits AppFlow to access the database through Data API.
     */
    @JvmName("vjgkinosuhxaiatq")
    public suspend fun dataApiRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataApiRoleArn = mapped
    }

    /**
     * @param value The name of an Amazon Redshift database.
     */
    @JvmName("hbmkefjtpjvgyrqb")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The JDBC URL of the Amazon Redshift cluster.
     */
    @JvmName("lmkgcrdthkjgjsud")
    public suspend fun databaseUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseUrl = mapped
    }

    /**
     * @param value ARN of the IAM role.
     */
    @JvmName("uqwymbwhtveppsjx")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs = ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshiftArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        bucketPrefix = bucketPrefix,
        clusterIdentifier = clusterIdentifier,
        dataApiRoleArn = dataApiRoleArn,
        databaseName = databaseName,
        databaseUrl = databaseUrl,
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
    )
}
