@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceUrl
 * @property isSandboxEnvironment Indicates whether the connector profile applies to a sandbox or production environment.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs(
    public val instanceUrl: Output<String>? = null,
    public val isSandboxEnvironment: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs.builder()
            .instanceUrl(instanceUrl?.applyValue({ args0 -> args0 }))
            .isSandboxEnvironment(isSandboxEnvironment?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgsBuilder
internal constructor() {
    private var instanceUrl: Output<String>? = null

    private var isSandboxEnvironment: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("jcxfxloumbwaqftk")
    public suspend fun instanceUrl(`value`: Output<String>) {
        this.instanceUrl = value
    }

    /**
     * @param value Indicates whether the connector profile applies to a sandbox or production environment.
     */
    @JvmName("vrakcwmelxyglyrw")
    public suspend fun isSandboxEnvironment(`value`: Output<Boolean>) {
        this.isSandboxEnvironment = value
    }

    /**
     * @param value
     */
    @JvmName("yjprfkephfnyajtt")
    public suspend fun instanceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceUrl = mapped
    }

    /**
     * @param value Indicates whether the connector profile applies to a sandbox or production environment.
     */
    @JvmName("irnsrsycvdhmlmea")
    public suspend fun isSandboxEnvironment(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSandboxEnvironment = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs =
        ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforceArgs(
            instanceUrl = instanceUrl,
            isSandboxEnvironment = isSandboxEnvironment,
        )
}
