@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property applicationHostUrl The location of the SAPOData resource.
 * @property applicationServicePath The application path to catalog service.
 * @property clientNumber The client number for the client creating the connection.
 * @property logonLanguage The logon language of SAPOData instance.
 * @property oauthProperties The SAPOData OAuth properties required for OAuth type authentication.
 * @property portNumber The port number of the SAPOData instance.
 * @property privateLinkServiceName
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs(
    public val applicationHostUrl: Output<String>,
    public val applicationServicePath: Output<String>,
    public val clientNumber: Output<String>,
    public val logonLanguage: Output<String>? = null,
    public val oauthProperties: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs>? =
        null,
    public val portNumber: Output<Int>,
    public val privateLinkServiceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs =
        com.pulumi.aws.appflow.inputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs.builder()
            .applicationHostUrl(applicationHostUrl.applyValue({ args0 -> args0 }))
            .applicationServicePath(applicationServicePath.applyValue({ args0 -> args0 }))
            .clientNumber(clientNumber.applyValue({ args0 -> args0 }))
            .logonLanguage(logonLanguage?.applyValue({ args0 -> args0 }))
            .oauthProperties(oauthProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .portNumber(portNumber.applyValue({ args0 -> args0 }))
            .privateLinkServiceName(privateLinkServiceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs].
 */
@PulumiTagMarker
public class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgsBuilder
internal constructor() {
    private var applicationHostUrl: Output<String>? = null

    private var applicationServicePath: Output<String>? = null

    private var clientNumber: Output<String>? = null

    private var logonLanguage: Output<String>? = null

    private var oauthProperties:
        Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs>? =
        null

    private var portNumber: Output<Int>? = null

    private var privateLinkServiceName: Output<String>? = null

    /**
     * @param value The location of the SAPOData resource.
     */
    @JvmName("yktrxllcrnkfwrqu")
    public suspend fun applicationHostUrl(`value`: Output<String>) {
        this.applicationHostUrl = value
    }

    /**
     * @param value The application path to catalog service.
     */
    @JvmName("jbsqyionvbcfspnf")
    public suspend fun applicationServicePath(`value`: Output<String>) {
        this.applicationServicePath = value
    }

    /**
     * @param value The client number for the client creating the connection.
     */
    @JvmName("jvhivgjjsxtgbeym")
    public suspend fun clientNumber(`value`: Output<String>) {
        this.clientNumber = value
    }

    /**
     * @param value The logon language of SAPOData instance.
     */
    @JvmName("efasudnichhnedtk")
    public suspend fun logonLanguage(`value`: Output<String>) {
        this.logonLanguage = value
    }

    /**
     * @param value The SAPOData OAuth properties required for OAuth type authentication.
     */
    @JvmName("etnuxehmlgljfawg")
    public suspend fun oauthProperties(`value`: Output<ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs>) {
        this.oauthProperties = value
    }

    /**
     * @param value The port number of the SAPOData instance.
     */
    @JvmName("deivqiskkhuailgt")
    public suspend fun portNumber(`value`: Output<Int>) {
        this.portNumber = value
    }

    /**
     * @param value
     */
    @JvmName("lhnouqmrquuhywbm")
    public suspend fun privateLinkServiceName(`value`: Output<String>) {
        this.privateLinkServiceName = value
    }

    /**
     * @param value The location of the SAPOData resource.
     */
    @JvmName("nygmsbnkhhhbppky")
    public suspend fun applicationHostUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationHostUrl = mapped
    }

    /**
     * @param value The application path to catalog service.
     */
    @JvmName("plrjkyjajyusvgom")
    public suspend fun applicationServicePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationServicePath = mapped
    }

    /**
     * @param value The client number for the client creating the connection.
     */
    @JvmName("rvsfnbogiebljfcl")
    public suspend fun clientNumber(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientNumber = mapped
    }

    /**
     * @param value The logon language of SAPOData instance.
     */
    @JvmName("txklfhspwdevrjqt")
    public suspend fun logonLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logonLanguage = mapped
    }

    /**
     * @param value The SAPOData OAuth properties required for OAuth type authentication.
     */
    @JvmName("ppesmhcmdsjugsxe")
    public suspend fun oauthProperties(`value`: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oauthProperties = mapped
    }

    /**
     * @param argument The SAPOData OAuth properties required for OAuth type authentication.
     */
    @JvmName("qplyqplsvkoggari")
    public suspend fun oauthProperties(argument: suspend ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthPropertiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oauthProperties = mapped
    }

    /**
     * @param value The port number of the SAPOData instance.
     */
    @JvmName("pswdmestkflrrgft")
    public suspend fun portNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.portNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("lkfvciwmmomtlkhr")
    public suspend fun privateLinkServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceName = mapped
    }

    internal fun build(): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs = ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataArgs(
        applicationHostUrl = applicationHostUrl ?: throw PulumiNullFieldException("applicationHostUrl"),
        applicationServicePath = applicationServicePath ?: throw
            PulumiNullFieldException("applicationServicePath"),
        clientNumber = clientNumber ?: throw PulumiNullFieldException("clientNumber"),
        logonLanguage = logonLanguage,
        oauthProperties = oauthProperties,
        portNumber = portNumber ?: throw PulumiNullFieldException("portNumber"),
        privateLinkServiceName = privateLinkServiceName,
    )
}
