@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketPrefix
 * @property errorHandlingConfig
 * @property intermediateBucketName
 * @property object
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs(
    public val bucketPrefix: Output<String>? = null,
    public val errorHandlingConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs>? =
        null,
    public val intermediateBucketName: Output<String>,
    public val `object`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs.builder()
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .errorHandlingConfig(
                errorHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .intermediateBucketName(intermediateBucketName.applyValue({ args0 -> args0 }))
            .`object`(`object`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgsBuilder internal constructor() {
    private var bucketPrefix: Output<String>? = null

    private var errorHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs>? =
        null

    private var intermediateBucketName: Output<String>? = null

    private var `object`: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("exinmvngedphsybi")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value
     */
    @JvmName("tggmckspiawgcinn")
    public suspend fun errorHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs>) {
        this.errorHandlingConfig = value
    }

    /**
     * @param value
     */
    @JvmName("nyceqkcbxafxxiua")
    public suspend fun intermediateBucketName(`value`: Output<String>) {
        this.intermediateBucketName = value
    }

    /**
     * @param value
     */
    @JvmName("arwyrmwiejhtvtpj")
    public suspend fun `object`(`value`: Output<String>) {
        this.`object` = value
    }

    /**
     * @param value
     */
    @JvmName("yslbfytpetxkothk")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("fgwqvyisuhrvwhmi")
    public suspend fun errorHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorHandlingConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lpxbqmgucpkjfvqs")
    public suspend fun errorHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftErrorHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.errorHandlingConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("qlcuedxptmdblmis")
    public suspend fun intermediateBucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.intermediateBucketName = mapped
    }

    /**
     * @param value
     */
    @JvmName("vvmcwewbouhbjoyq")
    public suspend fun `object`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`object` = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesRedshiftArgs(
            bucketPrefix = bucketPrefix,
            errorHandlingConfig = errorHandlingConfig,
            intermediateBucketName = intermediateBucketName ?: throw
                PulumiNullFieldException("intermediateBucketName"),
            `object` = `object` ?: throw PulumiNullFieldException("object"),
        )
}
