@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName
 * @property bucketPrefix
 * @property s3OutputFormatConfig
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val s3OutputFormatConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .s3OutputFormatConfig(
                s3OutputFormatConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesS3ArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var s3OutputFormatConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs>? =
        null

    /**
     * @param value
     */
    @JvmName("xtobxrcxivxjtmxd")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value
     */
    @JvmName("nqoarhtosmwgctuk")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value
     */
    @JvmName("qmordijewwidpgsf")
    public suspend fun s3OutputFormatConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs>) {
        this.s3OutputFormatConfig = value
    }

    /**
     * @param value
     */
    @JvmName("kywdrjflpyevhqci")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value
     */
    @JvmName("bsfjkaitoyedfwxj")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("siyfcsiotoywfhth")
    public suspend fun s3OutputFormatConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3OutputFormatConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aeftejdhaqvxenic")
    public suspend fun s3OutputFormatConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3OutputFormatConfig = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args =
        FlowDestinationFlowConfigDestinationConnectorPropertiesS3Args(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            bucketPrefix = bucketPrefix,
            s3OutputFormatConfig = s3OutputFormatConfig,
        )
}
