@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aggregationType Whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. Valid values are `None` and `SingleFile`.
 * @property targetFileSize The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination. Integer value.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs(
    public val aggregationType: Output<String>? = null,
    public val targetFileSize: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs.builder()
            .aggregationType(aggregationType?.applyValue({ args0 -> args0 }))
            .targetFileSize(targetFileSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs].
 */
@PulumiTagMarker
public class
FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgsBuilder
internal constructor() {
    private var aggregationType: Output<String>? = null

    private var targetFileSize: Output<Int>? = null

    /**
     * @param value Whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. Valid values are `None` and `SingleFile`.
     */
    @JvmName("amqyubnijohgsnli")
    public suspend fun aggregationType(`value`: Output<String>) {
        this.aggregationType = value
    }

    /**
     * @param value The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination. Integer value.
     */
    @JvmName("jshrumwplbtfsfcl")
    public suspend fun targetFileSize(`value`: Output<Int>) {
        this.targetFileSize = value
    }

    /**
     * @param value Whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated. Valid values are `None` and `SingleFile`.
     */
    @JvmName("gjmdtyyyybeqmmyk")
    public suspend fun aggregationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregationType = mapped
    }

    /**
     * @param value The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination. Integer value.
     */
    @JvmName("ujyelnoaayibhuss")
    public suspend fun targetFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFileSize = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs(
            aggregationType = aggregationType,
            targetFileSize = targetFileSize,
        )
}
