@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property aggregationConfig Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
 * @property fileType File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
 * @property prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
 * @property preserveSourceDataTyping Whether the data types from the source system need to be preserved (Only valid for `Parquet` file type)
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs(
    public val aggregationConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs>? =
        null,
    public val fileType: Output<String>? = null,
    public val prefixConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs>? =
        null,
    public val preserveSourceDataTyping: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs.builder()
            .aggregationConfig(aggregationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileType(fileType?.applyValue({ args0 -> args0 }))
            .prefixConfig(prefixConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preserveSourceDataTyping(preserveSourceDataTyping?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs].
 */
@PulumiTagMarker
public class
FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgsBuilder
internal constructor() {
    private var aggregationConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs>? =
        null

    private var fileType: Output<String>? = null

    private var prefixConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs>? =
        null

    private var preserveSourceDataTyping: Output<Boolean>? = null

    /**
     * @param value Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
     */
    @JvmName("qvyeyfiuqrqokujj")
    public suspend fun aggregationConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs>) {
        this.aggregationConfig = value
    }

    /**
     * @param value File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
     */
    @JvmName("jwfpyqvrarsnolwo")
    public suspend fun fileType(`value`: Output<String>) {
        this.fileType = value
    }

    /**
     * @param value Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
     */
    @JvmName("voovbuuhkjwdbwng")
    public suspend fun prefixConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs>) {
        this.prefixConfig = value
    }

    /**
     * @param value Whether the data types from the source system need to be preserved (Only valid for `Parquet` file type)
     */
    @JvmName("lhyroytpdgbwdaot")
    public suspend fun preserveSourceDataTyping(`value`: Output<Boolean>) {
        this.preserveSourceDataTyping = value
    }

    /**
     * @param value Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
     */
    @JvmName("gddjjrervyfnxxaa")
    public suspend fun aggregationConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregationConfig = mapped
    }

    /**
     * @param argument Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
     */
    @JvmName("xyduysfqlkmwkryw")
    public suspend fun aggregationConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigAggregationConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.aggregationConfig = mapped
    }

    /**
     * @param value File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
     */
    @JvmName("pqjjapcuvawddiee")
    public suspend fun fileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileType = mapped
    }

    /**
     * @param value Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
     */
    @JvmName("dijfhcrbeejapcsd")
    public suspend fun prefixConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixConfig = mapped
    }

    /**
     * @param argument Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
     */
    @JvmName("bgxtrugvabsmajhq")
    public suspend fun prefixConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigPrefixConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.prefixConfig = mapped
    }

    /**
     * @param value Whether the data types from the source system need to be preserved (Only valid for `Parquet` file type)
     */
    @JvmName("bjedhjcrgicmuhux")
    public suspend fun preserveSourceDataTyping(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preserveSourceDataTyping = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesS3S3OutputFormatConfigArgs(
            aggregationConfig = aggregationConfig,
            fileType = fileType,
            prefixConfig = prefixConfig,
            preserveSourceDataTyping = preserveSourceDataTyping,
        )
}
