@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property errorHandlingConfig
 * @property idFieldNames
 * @property objectPath
 * @property successResponseHandlingConfig Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data. See Success Response Handling Config for more details.
 * @property writeOperationType
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs(
    public val errorHandlingConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfigArgs>? =
        null,
    public val idFieldNames: Output<List<String>>? = null,
    public val objectPath: Output<String>,
    public val successResponseHandlingConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs>? =
        null,
    public val writeOperationType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs.builder()
            .errorHandlingConfig(
                errorHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .idFieldNames(idFieldNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .objectPath(objectPath.applyValue({ args0 -> args0 }))
            .successResponseHandlingConfig(
                successResponseHandlingConfig?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .writeOperationType(writeOperationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgsBuilder internal constructor() {
    private var errorHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfigArgs>? =
        null

    private var idFieldNames: Output<List<String>>? = null

    private var objectPath: Output<String>? = null

    private var successResponseHandlingConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs>? =
        null

    private var writeOperationType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lvlmmllaakeppltx")
    public suspend fun errorHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfigArgs>) {
        this.errorHandlingConfig = value
    }

    /**
     * @param value
     */
    @JvmName("nfhqgcvsjtenalxi")
    public suspend fun idFieldNames(`value`: Output<List<String>>) {
        this.idFieldNames = value
    }

    @JvmName("hlettudkgybxklfr")
    public suspend fun idFieldNames(vararg values: Output<String>) {
        this.idFieldNames = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("byvluvullciioqou")
    public suspend fun idFieldNames(values: List<Output<String>>) {
        this.idFieldNames = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("vnitloxkwpcduhhm")
    public suspend fun objectPath(`value`: Output<String>) {
        this.objectPath = value
    }

    /**
     * @param value Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data. See Success Response Handling Config for more details.
     */
    @JvmName("bdaecerdvjulkffb")
    public suspend fun successResponseHandlingConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs>) {
        this.successResponseHandlingConfig = value
    }

    /**
     * @param value
     */
    @JvmName("fdabxjejhtpwqxqt")
    public suspend fun writeOperationType(`value`: Output<String>) {
        this.writeOperationType = value
    }

    /**
     * @param value
     */
    @JvmName("sldfqrcynolfxekk")
    public suspend fun errorHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorHandlingConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ajtogkkmhrhgyihh")
    public suspend fun errorHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataErrorHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.errorHandlingConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("wadvtkjykpcugvrr")
    public suspend fun idFieldNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idFieldNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("dlyewqeaninbbmgh")
    public suspend fun idFieldNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.idFieldNames = mapped
    }

    /**
     * @param value
     */
    @JvmName("blfjyteuvbfrdvmy")
    public suspend fun objectPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectPath = mapped
    }

    /**
     * @param value Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data. See Success Response Handling Config for more details.
     */
    @JvmName("pswmeymididvdcrx")
    public suspend fun successResponseHandlingConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successResponseHandlingConfig = mapped
    }

    /**
     * @param argument Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data. See Success Response Handling Config for more details.
     */
    @JvmName("tauvpipytydltqpr")
    public suspend fun successResponseHandlingConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.successResponseHandlingConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("cwdamsykegjwtlob")
    public suspend fun writeOperationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeOperationType = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataArgs(
            errorHandlingConfig = errorHandlingConfig,
            idFieldNames = idFieldNames,
            objectPath = objectPath ?: throw PulumiNullFieldException("objectPath"),
            successResponseHandlingConfig = successResponseHandlingConfig,
            writeOperationType = writeOperationType,
        )
}
