@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of the Amazon S3 bucket.
 * @property bucketPrefix Amazon S3 bucket prefix.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs(
    public val bucketName: Output<String>? = null,
    public val bucketPrefix: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs].
 */
@PulumiTagMarker
public class
FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgsBuilder
internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    /**
     * @param value Name of the Amazon S3 bucket.
     */
    @JvmName("rtmwheisbmamtcsw")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("muxhahibbbipxkop")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value Name of the Amazon S3 bucket.
     */
    @JvmName("huoqpnbpbpjcfefy")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Amazon S3 bucket prefix.
     */
    @JvmName("dtvehpuqetadcsyo")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesSapoDataSuccessResponseHandlingConfigArgs(
            bucketName = bucketName,
            bucketPrefix = bucketPrefix,
        )
}
