@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName
 * @property bucketPrefix
 * @property s3OutputFormatConfig
 */
public data class FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val s3OutputFormatConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .s3OutputFormatConfig(
                s3OutputFormatConfig.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs].
 */
@PulumiTagMarker
public class FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var s3OutputFormatConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs>? =
        null

    /**
     * @param value
     */
    @JvmName("flripogsfymxxpun")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value
     */
    @JvmName("appqaivvypvitrhd")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value
     */
    @JvmName("sgjvqmsafbyojfxj")
    public suspend fun s3OutputFormatConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs>) {
        this.s3OutputFormatConfig = value
    }

    /**
     * @param value
     */
    @JvmName("djydoyoylulmgeay")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value
     */
    @JvmName("iwircierhxiqkdqc")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value
     */
    @JvmName("sslcuxumdtpdevml")
    public suspend fun s3OutputFormatConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3OutputFormatConfig = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qrwgjpwclvkhqtsl")
    public suspend fun s3OutputFormatConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3OutputFormatConfig = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            bucketPrefix = bucketPrefix,
            s3OutputFormatConfig = s3OutputFormatConfig ?: throw
                PulumiNullFieldException("s3OutputFormatConfig"),
        )
}
