@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property aggregationConfig Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
 * @property fileType File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
 * @property prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs(
    public val aggregationConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfigArgs>? =
        null,
    public val fileType: Output<String>? = null,
    public val prefixConfig: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs.builder()
            .aggregationConfig(aggregationConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileType(fileType?.applyValue({ args0 -> args0 }))
            .prefixConfig(prefixConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs].
 */
@PulumiTagMarker
public class
FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgsBuilder
internal constructor() {
    private var aggregationConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfigArgs>? =
        null

    private var fileType: Output<String>? = null

    private var prefixConfig:
        Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs>? =
        null

    /**
     * @param value Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
     */
    @JvmName("rcgbymseekijouqe")
    public suspend fun aggregationConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfigArgs>) {
        this.aggregationConfig = value
    }

    /**
     * @param value File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
     */
    @JvmName("smlgwbvgrfeagcca")
    public suspend fun fileType(`value`: Output<String>) {
        this.fileType = value
    }

    /**
     * @param value Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
     */
    @JvmName("golnbeanpdlirxsd")
    public suspend fun prefixConfig(`value`: Output<FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs>) {
        this.prefixConfig = value
    }

    /**
     * @param value Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
     */
    @JvmName("etwufhmjfbjqmiuh")
    public suspend fun aggregationConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregationConfig = mapped
    }

    /**
     * @param argument Aggregation settings that you can use to customize the output format of your flow data. See Aggregation Config for more details.
     */
    @JvmName("bbhlcrmyrakckjqk")
    public suspend fun aggregationConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigAggregationConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.aggregationConfig = mapped
    }

    /**
     * @param value File type that Amazon AppFlow places in the Amazon S3 bucket. Valid values are `CSV`, `JSON`, and `PARQUET`.
     */
    @JvmName("uwqoohjjkurvkmqn")
    public suspend fun fileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileType = mapped
    }

    /**
     * @param value Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
     */
    @JvmName("rbkpvtcvakjjisxo")
    public suspend fun prefixConfig(`value`: FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixConfig = mapped
    }

    /**
     * @param argument Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket. You can name folders according to the flow frequency and date. See Prefix Config for more details.
     */
    @JvmName("igsgyilxibmxxqgj")
    public suspend fun prefixConfig(argument: suspend FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.prefixConfig = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigArgs(
            aggregationConfig = aggregationConfig,
            fileType = fileType,
            prefixConfig = prefixConfig ?: throw PulumiNullFieldException("prefixConfig"),
        )
}
