@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property prefixFormat Determines the level of granularity that's included in the prefix. Valid values are `YEAR`, `MONTH`, `DAY`, `HOUR`, and `MINUTE`.
 * @property prefixHierarchies Determines whether the destination file path includes either or both of the selected elements. Valid values are `EXECUTION_ID` and `SCHEMA_VERSION`
 * @property prefixType Determines the format of the prefix, and whether it applies to the file name, file path, or both. Valid values are `FILENAME`, `PATH`, and `PATH_AND_FILENAME`.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs(
    public val prefixFormat: Output<String>? = null,
    public val prefixHierarchies: Output<List<String>>? = null,
    public val prefixType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs.builder()
            .prefixFormat(prefixFormat?.applyValue({ args0 -> args0 }))
            .prefixHierarchies(prefixHierarchies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixType(prefixType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs].
 */
@PulumiTagMarker
public class
FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgsBuilder
internal constructor() {
    private var prefixFormat: Output<String>? = null

    private var prefixHierarchies: Output<List<String>>? = null

    private var prefixType: Output<String>? = null

    /**
     * @param value Determines the level of granularity that's included in the prefix. Valid values are `YEAR`, `MONTH`, `DAY`, `HOUR`, and `MINUTE`.
     */
    @JvmName("qumrfncfbkgomdmf")
    public suspend fun prefixFormat(`value`: Output<String>) {
        this.prefixFormat = value
    }

    /**
     * @param value Determines whether the destination file path includes either or both of the selected elements. Valid values are `EXECUTION_ID` and `SCHEMA_VERSION`
     */
    @JvmName("dlimcwyvdyqcrhck")
    public suspend fun prefixHierarchies(`value`: Output<List<String>>) {
        this.prefixHierarchies = value
    }

    @JvmName("krjrggferpwedbuq")
    public suspend fun prefixHierarchies(vararg values: Output<String>) {
        this.prefixHierarchies = Output.all(values.asList())
    }

    /**
     * @param values Determines whether the destination file path includes either or both of the selected elements. Valid values are `EXECUTION_ID` and `SCHEMA_VERSION`
     */
    @JvmName("yixwebavlghlvcre")
    public suspend fun prefixHierarchies(values: List<Output<String>>) {
        this.prefixHierarchies = Output.all(values)
    }

    /**
     * @param value Determines the format of the prefix, and whether it applies to the file name, file path, or both. Valid values are `FILENAME`, `PATH`, and `PATH_AND_FILENAME`.
     */
    @JvmName("hsymposujwmpcavj")
    public suspend fun prefixType(`value`: Output<String>) {
        this.prefixType = value
    }

    /**
     * @param value Determines the level of granularity that's included in the prefix. Valid values are `YEAR`, `MONTH`, `DAY`, `HOUR`, and `MINUTE`.
     */
    @JvmName("ocgipcovlvsowcvj")
    public suspend fun prefixFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixFormat = mapped
    }

    /**
     * @param value Determines whether the destination file path includes either or both of the selected elements. Valid values are `EXECUTION_ID` and `SCHEMA_VERSION`
     */
    @JvmName("wrbklhngjmvottfk")
    public suspend fun prefixHierarchies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixHierarchies = mapped
    }

    /**
     * @param values Determines whether the destination file path includes either or both of the selected elements. Valid values are `EXECUTION_ID` and `SCHEMA_VERSION`
     */
    @JvmName("cohkvowjiubpafuf")
    public suspend fun prefixHierarchies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixHierarchies = mapped
    }

    /**
     * @param value Determines the format of the prefix, and whether it applies to the file name, file path, or both. Valid values are `FILENAME`, `PATH`, and `PATH_AND_FILENAME`.
     */
    @JvmName("upwixkwlvghvmalc")
    public suspend fun prefixType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixType = mapped
    }

    internal fun build(): FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs =
        FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolverS3OutputFormatConfigPrefixConfigArgs(
            prefixFormat = prefixFormat,
            prefixHierarchies = prefixHierarchies,
            prefixType = prefixType ?: throw PulumiNullFieldException("prefixType"),
        )
}
