@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property glueDataCatalog
 */
public data class FlowMetadataCatalogConfigArgs(
    public val glueDataCatalog: Output<FlowMetadataCatalogConfigGlueDataCatalogArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigArgs.builder()
            .glueDataCatalog(
                glueDataCatalog?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FlowMetadataCatalogConfigArgs].
 */
@PulumiTagMarker
public class FlowMetadataCatalogConfigArgsBuilder internal constructor() {
    private var glueDataCatalog: Output<FlowMetadataCatalogConfigGlueDataCatalogArgs>? = null

    /**
     * @param value
     */
    @JvmName("xqjkdqympkqharqb")
    public suspend fun glueDataCatalog(`value`: Output<FlowMetadataCatalogConfigGlueDataCatalogArgs>) {
        this.glueDataCatalog = value
    }

    /**
     * @param value
     */
    @JvmName("upajmbssntbuvygn")
    public suspend fun glueDataCatalog(`value`: FlowMetadataCatalogConfigGlueDataCatalogArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.glueDataCatalog = mapped
    }

    /**
     * @param argument
     */
    @JvmName("whffcwtijvmyngxk")
    public suspend fun glueDataCatalog(argument: suspend FlowMetadataCatalogConfigGlueDataCatalogArgsBuilder.() -> Unit) {
        val toBeMapped = FlowMetadataCatalogConfigGlueDataCatalogArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.glueDataCatalog = mapped
    }

    internal fun build(): FlowMetadataCatalogConfigArgs = FlowMetadataCatalogConfigArgs(
        glueDataCatalog = glueDataCatalog,
    )
}
