@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigGlueDataCatalogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of an existing Glue database to store the metadata tables that Amazon AppFlow creates.
 * @property roleArn The ARN of an IAM role that grants AppFlow the permissions it needs to create Data Catalog tables, databases, and partitions.
 * @property tablePrefix A naming prefix for each Data Catalog table that Amazon AppFlow creates
 */
public data class FlowMetadataCatalogConfigGlueDataCatalogArgs(
    public val databaseName: Output<String>,
    public val roleArn: Output<String>,
    public val tablePrefix: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigGlueDataCatalogArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigGlueDataCatalogArgs = com.pulumi.aws.appflow.inputs.FlowMetadataCatalogConfigGlueDataCatalogArgs.builder()
        .databaseName(databaseName.applyValue({ args0 -> args0 }))
        .roleArn(roleArn.applyValue({ args0 -> args0 }))
        .tablePrefix(tablePrefix.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowMetadataCatalogConfigGlueDataCatalogArgs].
 */
@PulumiTagMarker
public class FlowMetadataCatalogConfigGlueDataCatalogArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var tablePrefix: Output<String>? = null

    /**
     * @param value The name of an existing Glue database to store the metadata tables that Amazon AppFlow creates.
     */
    @JvmName("kxerllpcskypxufx")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The ARN of an IAM role that grants AppFlow the permissions it needs to create Data Catalog tables, databases, and partitions.
     */
    @JvmName("ufrcybxrvvsxsisu")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A naming prefix for each Data Catalog table that Amazon AppFlow creates
     */
    @JvmName("thyurptlrpjyasgp")
    public suspend fun tablePrefix(`value`: Output<String>) {
        this.tablePrefix = value
    }

    /**
     * @param value The name of an existing Glue database to store the metadata tables that Amazon AppFlow creates.
     */
    @JvmName("yafulgaalsketdxh")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The ARN of an IAM role that grants AppFlow the permissions it needs to create Data Catalog tables, databases, and partitions.
     */
    @JvmName("macrscexlbugiwck")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A naming prefix for each Data Catalog table that Amazon AppFlow creates
     */
    @JvmName("vsakaqkfbeoffwgq")
    public suspend fun tablePrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tablePrefix = mapped
    }

    internal fun build(): FlowMetadataCatalogConfigGlueDataCatalogArgs =
        FlowMetadataCatalogConfigGlueDataCatalogArgs(
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
            tablePrefix = tablePrefix ?: throw PulumiNullFieldException("tablePrefix"),
        )
}
