@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3InputFileType File type that Amazon AppFlow gets from your Amazon S3 bucket. Valid values are `CSV` and `JSON`.
 */
public data class FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs(
    public val s3InputFileType: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs.builder()
            .s3InputFileType(s3InputFileType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs].
 */
@PulumiTagMarker
public class FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgsBuilder internal constructor() {
    private var s3InputFileType: Output<String>? = null

    /**
     * @param value File type that Amazon AppFlow gets from your Amazon S3 bucket. Valid values are `CSV` and `JSON`.
     */
    @JvmName("scmdntnsiuayoedf")
    public suspend fun s3InputFileType(`value`: Output<String>) {
        this.s3InputFileType = value
    }

    /**
     * @param value File type that Amazon AppFlow gets from your Amazon S3 bucket. Valid values are `CSV` and `JSON`.
     */
    @JvmName("qpaxbcoerdorccfk")
    public suspend fun s3InputFileType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3InputFileType = mapped
    }

    internal fun build(): FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs =
        FlowSourceFlowConfigSourceConnectorPropertiesS3S3InputFormatConfigArgs(
            s3InputFileType = s3InputFileType,
        )
}
