@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property connectorOperators Operation to be performed on the provided source fields. See Connector Operator for details.
 * @property destinationField Field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
 * @property sourceFields Source fields to which a particular task is applied.
 * @property taskProperties Map used to store task-related information. The execution service looks for particular information based on the `TaskType`. Valid keys are `VALUE`, `VALUES`, `DATA_TYPE`, `UPPER_BOUND`, `LOWER_BOUND`, `SOURCE_DATA_TYPE`, `DESTINATION_DATA_TYPE`, `VALIDATION_ACTION`, `MASK_VALUE`, `MASK_LENGTH`, `TRUNCATE_LENGTH`, `MATH_OPERATION_FIELDS_ORDER`, `CONCAT_FORMAT`, `SUBFIELD_CATEGORY_MAP`, and `EXCLUDE_SOURCE_FIELDS_LIST`.
 * @property taskType Particular task implementation that Amazon AppFlow performs. Valid values are `Arithmetic`, `Filter`, `Map`, `Map_all`, `Mask`, `Merge`, `Passthrough`, `Truncate`, and `Validate`.
 */
public data class FlowTaskArgs(
    public val connectorOperators: Output<List<FlowTaskConnectorOperatorArgs>>? = null,
    public val destinationField: Output<String>? = null,
    public val sourceFields: Output<List<String>>? = null,
    public val taskProperties: Output<Map<String, String>>? = null,
    public val taskType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowTaskArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowTaskArgs =
        com.pulumi.aws.appflow.inputs.FlowTaskArgs.builder()
            .connectorOperators(
                connectorOperators?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destinationField(destinationField?.applyValue({ args0 -> args0 }))
            .sourceFields(sourceFields?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .taskProperties(
                taskProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .taskType(taskType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowTaskArgs].
 */
@PulumiTagMarker
public class FlowTaskArgsBuilder internal constructor() {
    private var connectorOperators: Output<List<FlowTaskConnectorOperatorArgs>>? = null

    private var destinationField: Output<String>? = null

    private var sourceFields: Output<List<String>>? = null

    private var taskProperties: Output<Map<String, String>>? = null

    private var taskType: Output<String>? = null

    /**
     * @param value Operation to be performed on the provided source fields. See Connector Operator for details.
     */
    @JvmName("qguometfblgqmgdr")
    public suspend fun connectorOperators(`value`: Output<List<FlowTaskConnectorOperatorArgs>>) {
        this.connectorOperators = value
    }

    @JvmName("vdusnolviumigbxx")
    public suspend fun connectorOperators(vararg values: Output<FlowTaskConnectorOperatorArgs>) {
        this.connectorOperators = Output.all(values.asList())
    }

    /**
     * @param values Operation to be performed on the provided source fields. See Connector Operator for details.
     */
    @JvmName("ccwedvmmbypcthdg")
    public suspend fun connectorOperators(values: List<Output<FlowTaskConnectorOperatorArgs>>) {
        this.connectorOperators = Output.all(values)
    }

    /**
     * @param value Field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
     */
    @JvmName("kicxgtcukhjussmk")
    public suspend fun destinationField(`value`: Output<String>) {
        this.destinationField = value
    }

    /**
     * @param value Source fields to which a particular task is applied.
     */
    @JvmName("qbimgfgfiqfdjmsr")
    public suspend fun sourceFields(`value`: Output<List<String>>) {
        this.sourceFields = value
    }

    @JvmName("evpqlqlrjcfbswkp")
    public suspend fun sourceFields(vararg values: Output<String>) {
        this.sourceFields = Output.all(values.asList())
    }

    /**
     * @param values Source fields to which a particular task is applied.
     */
    @JvmName("gjwgkvagnhsybnmr")
    public suspend fun sourceFields(values: List<Output<String>>) {
        this.sourceFields = Output.all(values)
    }

    /**
     * @param value Map used to store task-related information. The execution service looks for particular information based on the `TaskType`. Valid keys are `VALUE`, `VALUES`, `DATA_TYPE`, `UPPER_BOUND`, `LOWER_BOUND`, `SOURCE_DATA_TYPE`, `DESTINATION_DATA_TYPE`, `VALIDATION_ACTION`, `MASK_VALUE`, `MASK_LENGTH`, `TRUNCATE_LENGTH`, `MATH_OPERATION_FIELDS_ORDER`, `CONCAT_FORMAT`, `SUBFIELD_CATEGORY_MAP`, and `EXCLUDE_SOURCE_FIELDS_LIST`.
     */
    @JvmName("ctieptwduenmcrjb")
    public suspend fun taskProperties(`value`: Output<Map<String, String>>) {
        this.taskProperties = value
    }

    /**
     * @param value Particular task implementation that Amazon AppFlow performs. Valid values are `Arithmetic`, `Filter`, `Map`, `Map_all`, `Mask`, `Merge`, `Passthrough`, `Truncate`, and `Validate`.
     */
    @JvmName("xvhqgegnbkkuertr")
    public suspend fun taskType(`value`: Output<String>) {
        this.taskType = value
    }

    /**
     * @param value Operation to be performed on the provided source fields. See Connector Operator for details.
     */
    @JvmName("bqsddgtuerryslgd")
    public suspend fun connectorOperators(`value`: List<FlowTaskConnectorOperatorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorOperators = mapped
    }

    /**
     * @param argument Operation to be performed on the provided source fields. See Connector Operator for details.
     */
    @JvmName("mjvchddmpmlilyvd")
    public suspend fun connectorOperators(argument: List<suspend FlowTaskConnectorOperatorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FlowTaskConnectorOperatorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectorOperators = mapped
    }

    /**
     * @param argument Operation to be performed on the provided source fields. See Connector Operator for details.
     */
    @JvmName("jocdupghjqqfnbxp")
    public suspend fun connectorOperators(vararg argument: suspend FlowTaskConnectorOperatorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FlowTaskConnectorOperatorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectorOperators = mapped
    }

    /**
     * @param argument Operation to be performed on the provided source fields. See Connector Operator for details.
     */
    @JvmName("velqgyrsothywytc")
    public suspend fun connectorOperators(argument: suspend FlowTaskConnectorOperatorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FlowTaskConnectorOperatorArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.connectorOperators = mapped
    }

    /**
     * @param values Operation to be performed on the provided source fields. See Connector Operator for details.
     */
    @JvmName("tqefaaytgjckcrfo")
    public suspend fun connectorOperators(vararg values: FlowTaskConnectorOperatorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectorOperators = mapped
    }

    /**
     * @param value Field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
     */
    @JvmName("ngrcrbovacaouocm")
    public suspend fun destinationField(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationField = mapped
    }

    /**
     * @param value Source fields to which a particular task is applied.
     */
    @JvmName("kyfvvefngrwlwgtc")
    public suspend fun sourceFields(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFields = mapped
    }

    /**
     * @param values Source fields to which a particular task is applied.
     */
    @JvmName("oalyfairjckrlifh")
    public suspend fun sourceFields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceFields = mapped
    }

    /**
     * @param value Map used to store task-related information. The execution service looks for particular information based on the `TaskType`. Valid keys are `VALUE`, `VALUES`, `DATA_TYPE`, `UPPER_BOUND`, `LOWER_BOUND`, `SOURCE_DATA_TYPE`, `DESTINATION_DATA_TYPE`, `VALIDATION_ACTION`, `MASK_VALUE`, `MASK_LENGTH`, `TRUNCATE_LENGTH`, `MATH_OPERATION_FIELDS_ORDER`, `CONCAT_FORMAT`, `SUBFIELD_CATEGORY_MAP`, and `EXCLUDE_SOURCE_FIELDS_LIST`.
     */
    @JvmName("crblfplstlbmdhak")
    public suspend fun taskProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskProperties = mapped
    }

    /**
     * @param values Map used to store task-related information. The execution service looks for particular information based on the `TaskType`. Valid keys are `VALUE`, `VALUES`, `DATA_TYPE`, `UPPER_BOUND`, `LOWER_BOUND`, `SOURCE_DATA_TYPE`, `DESTINATION_DATA_TYPE`, `VALIDATION_ACTION`, `MASK_VALUE`, `MASK_LENGTH`, `TRUNCATE_LENGTH`, `MATH_OPERATION_FIELDS_ORDER`, `CONCAT_FORMAT`, `SUBFIELD_CATEGORY_MAP`, and `EXCLUDE_SOURCE_FIELDS_LIST`.
     */
    @JvmName("sntvhydpxctorkxr")
    public fun taskProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskProperties = mapped
    }

    /**
     * @param value Particular task implementation that Amazon AppFlow performs. Valid values are `Arithmetic`, `Filter`, `Map`, `Map_all`, `Mask`, `Merge`, `Passthrough`, `Truncate`, and `Validate`.
     */
    @JvmName("bdhisdpmuwwnnutm")
    public suspend fun taskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskType = mapped
    }

    internal fun build(): FlowTaskArgs = FlowTaskArgs(
        connectorOperators = connectorOperators,
        destinationField = destinationField,
        sourceFields = sourceFields,
        taskProperties = taskProperties,
        taskType = taskType ?: throw PulumiNullFieldException("taskType"),
    )
}
