@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property triggerProperties Configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the `Scheduled` trigger type. See Scheduled Trigger Properties for details.
 * @property triggerType Type of flow trigger. Valid values are `Scheduled`, `Event`, and `OnDemand`.
 */
public data class FlowTriggerConfigArgs(
    public val triggerProperties: Output<FlowTriggerConfigTriggerPropertiesArgs>? = null,
    public val triggerType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs =
        com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs.builder()
            .triggerProperties(triggerProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .triggerType(triggerType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowTriggerConfigArgs].
 */
@PulumiTagMarker
public class FlowTriggerConfigArgsBuilder internal constructor() {
    private var triggerProperties: Output<FlowTriggerConfigTriggerPropertiesArgs>? = null

    private var triggerType: Output<String>? = null

    /**
     * @param value Configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the `Scheduled` trigger type. See Scheduled Trigger Properties for details.
     */
    @JvmName("lebwllcbukgkgdrr")
    public suspend fun triggerProperties(`value`: Output<FlowTriggerConfigTriggerPropertiesArgs>) {
        this.triggerProperties = value
    }

    /**
     * @param value Type of flow trigger. Valid values are `Scheduled`, `Event`, and `OnDemand`.
     */
    @JvmName("uetpabbrgmmmvasx")
    public suspend fun triggerType(`value`: Output<String>) {
        this.triggerType = value
    }

    /**
     * @param value Configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the `Scheduled` trigger type. See Scheduled Trigger Properties for details.
     */
    @JvmName("atdhulxihhidvrre")
    public suspend fun triggerProperties(`value`: FlowTriggerConfigTriggerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerProperties = mapped
    }

    /**
     * @param argument Configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the `Scheduled` trigger type. See Scheduled Trigger Properties for details.
     */
    @JvmName("bxrbdwaqpicmoyug")
    public suspend fun triggerProperties(argument: suspend FlowTriggerConfigTriggerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FlowTriggerConfigTriggerPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.triggerProperties = mapped
    }

    /**
     * @param value Type of flow trigger. Valid values are `Scheduled`, `Event`, and `OnDemand`.
     */
    @JvmName("fwlyfwknyciyfbds")
    public suspend fun triggerType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): FlowTriggerConfigArgs = FlowTriggerConfigArgs(
        triggerProperties = triggerProperties,
        triggerType = triggerType ?: throw PulumiNullFieldException("triggerType"),
    )
}
