@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.inputs

import com.pulumi.aws.appflow.inputs.FlowTriggerConfigTriggerPropertiesScheduledArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataPullMode Whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. Valid values are `Incremental` and `Complete`.
 * @property firstExecutionFrom Date range for the records to import from the connector in the first flow run. Must be a valid RFC3339 timestamp.
 * @property scheduleEndTime Scheduled end time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
 * @property scheduleExpression Scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)`.
 * @property scheduleOffset Optional offset that is added to the time interval for a schedule-triggered flow. Maximum value of 36000.
 * @property scheduleStartTime Scheduled start time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
 * @property timezone Time zone used when referring to the date and time of a scheduled-triggered flow, such as `America/New_York`.
 * <!--Start PulumiCodeChooser -->
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appflow.Flow;
 * import com.pulumi.aws.appflow.FlowArgs;
 * import com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Flow("example", FlowArgs.builder()
 *             .triggerConfig(FlowTriggerConfigArgs.builder()
 *                 .scheduled(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appflow:Flow
 *     properties:
 *       triggerConfig:
 *         scheduled:
 *           - scheduleExpression: rate(1minutes)
 * ```
 * <!--End PulumiCodeChooser -->
 */
public data class FlowTriggerConfigTriggerPropertiesScheduledArgs(
    public val dataPullMode: Output<String>? = null,
    public val firstExecutionFrom: Output<String>? = null,
    public val scheduleEndTime: Output<String>? = null,
    public val scheduleExpression: Output<String>,
    public val scheduleOffset: Output<Int>? = null,
    public val scheduleStartTime: Output<String>? = null,
    public val timezone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appflow.inputs.FlowTriggerConfigTriggerPropertiesScheduledArgs> {
    override fun toJava(): com.pulumi.aws.appflow.inputs.FlowTriggerConfigTriggerPropertiesScheduledArgs =
        com.pulumi.aws.appflow.inputs.FlowTriggerConfigTriggerPropertiesScheduledArgs.builder()
            .dataPullMode(dataPullMode?.applyValue({ args0 -> args0 }))
            .firstExecutionFrom(firstExecutionFrom?.applyValue({ args0 -> args0 }))
            .scheduleEndTime(scheduleEndTime?.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression.applyValue({ args0 -> args0 }))
            .scheduleOffset(scheduleOffset?.applyValue({ args0 -> args0 }))
            .scheduleStartTime(scheduleStartTime?.applyValue({ args0 -> args0 }))
            .timezone(timezone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowTriggerConfigTriggerPropertiesScheduledArgs].
 */
@PulumiTagMarker
public class FlowTriggerConfigTriggerPropertiesScheduledArgsBuilder internal constructor() {
    private var dataPullMode: Output<String>? = null

    private var firstExecutionFrom: Output<String>? = null

    private var scheduleEndTime: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    private var scheduleOffset: Output<Int>? = null

    private var scheduleStartTime: Output<String>? = null

    private var timezone: Output<String>? = null

    /**
     * @param value Whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. Valid values are `Incremental` and `Complete`.
     */
    @JvmName("fqplfnngglfarpdp")
    public suspend fun dataPullMode(`value`: Output<String>) {
        this.dataPullMode = value
    }

    /**
     * @param value Date range for the records to import from the connector in the first flow run. Must be a valid RFC3339 timestamp.
     */
    @JvmName("lpmedgcwynnubhqn")
    public suspend fun firstExecutionFrom(`value`: Output<String>) {
        this.firstExecutionFrom = value
    }

    /**
     * @param value Scheduled end time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
     */
    @JvmName("cwvgrfmycknjvras")
    public suspend fun scheduleEndTime(`value`: Output<String>) {
        this.scheduleEndTime = value
    }

    /**
     * @param value Scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)`.
     */
    @JvmName("ogeomvfiurumdwwv")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value Optional offset that is added to the time interval for a schedule-triggered flow. Maximum value of 36000.
     */
    @JvmName("csnwxfpuejubnchl")
    public suspend fun scheduleOffset(`value`: Output<Int>) {
        this.scheduleOffset = value
    }

    /**
     * @param value Scheduled start time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
     */
    @JvmName("ahlhmgwbtoxaevbo")
    public suspend fun scheduleStartTime(`value`: Output<String>) {
        this.scheduleStartTime = value
    }

    /**
     * @param value Time zone used when referring to the date and time of a scheduled-triggered flow, such as `America/New_York`.
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appflow.Flow;
     * import com.pulumi.aws.appflow.FlowArgs;
     * import com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var example = new Flow("example", FlowArgs.builder()
     *             .triggerConfig(FlowTriggerConfigArgs.builder()
     *                 .scheduled(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:appflow:Flow
     *     properties:
     *       triggerConfig:
     *         scheduled:
     *           - scheduleExpression: rate(1minutes)
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("bwcaokyaopglnofm")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value Whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run. Valid values are `Incremental` and `Complete`.
     */
    @JvmName("oeipwbtjkphbheih")
    public suspend fun dataPullMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPullMode = mapped
    }

    /**
     * @param value Date range for the records to import from the connector in the first flow run. Must be a valid RFC3339 timestamp.
     */
    @JvmName("hcyxnljsgflgmvsp")
    public suspend fun firstExecutionFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstExecutionFrom = mapped
    }

    /**
     * @param value Scheduled end time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
     */
    @JvmName("smaibteaflxqctpq")
    public suspend fun scheduleEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleEndTime = mapped
    }

    /**
     * @param value Scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)`.
     */
    @JvmName("gcglvacrptluxjuq")
    public suspend fun scheduleExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    /**
     * @param value Optional offset that is added to the time interval for a schedule-triggered flow. Maximum value of 36000.
     */
    @JvmName("wjidduekooptrmxb")
    public suspend fun scheduleOffset(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleOffset = mapped
    }

    /**
     * @param value Scheduled start time for a schedule-triggered flow. Must be a valid RFC3339 timestamp.
     */
    @JvmName("ekhsutpepxeltvwv")
    public suspend fun scheduleStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleStartTime = mapped
    }

    /**
     * @param value Time zone used when referring to the date and time of a scheduled-triggered flow, such as `America/New_York`.
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.appflow.Flow;
     * import com.pulumi.aws.appflow.FlowArgs;
     * import com.pulumi.aws.appflow.inputs.FlowTriggerConfigArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var example = new Flow("example", FlowArgs.builder()
     *             .triggerConfig(FlowTriggerConfigArgs.builder()
     *                 .scheduled(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   example:
     *     type: aws:appflow:Flow
     *     properties:
     *       triggerConfig:
     *         scheduled:
     *           - scheduleExpression: rate(1minutes)
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("ayrrenudxfpuhrna")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    internal fun build(): FlowTriggerConfigTriggerPropertiesScheduledArgs =
        FlowTriggerConfigTriggerPropertiesScheduledArgs(
            dataPullMode = dataPullMode,
            firstExecutionFrom = firstExecutionFrom,
            scheduleEndTime = scheduleEndTime,
            scheduleExpression = scheduleExpression ?: throw PulumiNullFieldException("scheduleExpression"),
            scheduleOffset = scheduleOffset,
            scheduleStartTime = scheduleStartTime,
            timezone = timezone,
        )
}
