@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property amplitude The connector-specific credentials required when using Amplitude. See Amplitude Connector Profile Credentials for more details.
 * @property customConnector The connector-specific profile properties required when using the custom connector. See Custom Connector Profile Properties for more details.
 * @property datadog Connector-specific properties required when using Datadog. See Generic Connector Profile Properties for more details.
 * @property dynatrace The connector-specific properties required when using Dynatrace. See Generic Connector Profile Properties for more details.
 * @property googleAnalytics The connector-specific credentials required when using Google Analytics. See Google Analytics Connector Profile Credentials for more details.
 * @property honeycode The connector-specific credentials required when using Amazon Honeycode. See Honeycode Connector Profile Credentials for more details.
 * @property inforNexus The connector-specific properties required when using Infor Nexus. See Generic Connector Profile Properties for more details.
 * @property marketo Connector-specific properties required when using Marketo. See Generic Connector Profile Properties for more details.
 * @property redshift Connector-specific properties required when using Amazon Redshift. See Redshift Connector Profile Properties for more details.
 * @property salesforce The connector-specific properties required when using Salesforce. See Salesforce Connector Profile Properties for more details.
 * @property sapoData The connector-specific properties required when using SAPOData. See SAPOData Connector Profile Properties for more details.
 * @property serviceNow The connector-specific properties required when using ServiceNow. See Generic Connector Profile Properties for more details.
 * @property singular Connector-specific credentials required when using Singular. See Singular Connector Profile Credentials for more details.
 * @property slack Connector-specific properties required when using Slack. See Generic Connector Profile Properties for more details.
 * @property snowflake The connector-specific properties required when using Snowflake. See Snowflake Connector Profile Properties for more details.
 * @property trendmicro The connector-specific credentials required when using Trend Micro. See Trend Micro Connector Profile Credentials for more details.
 * @property veeva Connector-specific properties required when using Veeva. See Generic Connector Profile Properties for more details.
 * @property zendesk Connector-specific properties required when using Zendesk. See Generic Connector Profile Properties for more details.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfileProperties(
    public val amplitude: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitude? =
        null,
    public val customConnector: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnector? = null,
    public val datadog: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadog? =
        null,
    public val dynatrace: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatrace? =
        null,
    public val googleAnalytics: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalytics? = null,
    public val honeycode: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycode? =
        null,
    public val inforNexus: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexus? =
        null,
    public val marketo: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketo? =
        null,
    public val redshift: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshift? =
        null,
    public val salesforce: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforce? =
        null,
    public val sapoData: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoData? =
        null,
    public val serviceNow: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNow? =
        null,
    public val singular: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingular? =
        null,
    public val slack: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlack? = null,
    public val snowflake: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflake? =
        null,
    public val trendmicro: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicro? =
        null,
    public val veeva: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeeva? = null,
    public val zendesk: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendesk? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfileProperties): ConnectorProfileConnectorProfileConfigConnectorProfileProperties =
            ConnectorProfileConnectorProfileConfigConnectorProfileProperties(
                amplitude = javaType.amplitude().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesAmplitude.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                customConnector = javaType.customConnector().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnector.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                datadog = javaType.datadog().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDatadog.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dynatrace = javaType.dynatrace().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesDynatrace.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                googleAnalytics = javaType.googleAnalytics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesGoogleAnalytics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                honeycode = javaType.honeycode().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesHoneycode.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                inforNexus = javaType.inforNexus().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesInforNexus.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                marketo = javaType.marketo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesMarketo.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                redshift = javaType.redshift().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesRedshift.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                salesforce = javaType.salesforce().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSalesforce.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sapoData = javaType.sapoData().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoData.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                serviceNow = javaType.serviceNow().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesServiceNow.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singular = javaType.singular().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSingular.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                slack = javaType.slack().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSlack.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                snowflake = javaType.snowflake().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflake.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                trendmicro = javaType.trendmicro().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesTrendmicro.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                veeva = javaType.veeva().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesVeeva.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                zendesk = javaType.zendesk().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesZendesk.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
