@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property oauth2GrantType
 * @property tokenUrl
 * @property tokenUrlCustomProperties Associates your token URL with a map of properties that you define. Use this parameter to provide any additional details that the connector requires to authenticate your request.
 */
public data class
ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2Properties(
    public val oauth2GrantType: String,
    public val tokenUrl: String,
    public val tokenUrlCustomProperties: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2Properties): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2Properties =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesCustomConnectorOauth2Properties(
                oauth2GrantType = javaType.oauth2GrantType(),
                tokenUrl = javaType.tokenUrl(),
                tokenUrlCustomProperties = javaType.tokenUrlCustomProperties().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
            )
    }
}
