@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationHostUrl The location of the SAPOData resource.
 * @property applicationServicePath The application path to catalog service.
 * @property clientNumber The client number for the client creating the connection.
 * @property logonLanguage The logon language of SAPOData instance.
 * @property oauthProperties The SAPOData OAuth properties required for OAuth type authentication.
 * @property portNumber The port number of the SAPOData instance.
 * @property privateLinkServiceName
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoData(
    public val applicationHostUrl: String,
    public val applicationServicePath: String,
    public val clientNumber: String,
    public val logonLanguage: String? = null,
    public val oauthProperties: ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthProperties? =
        null,
    public val portNumber: Int,
    public val privateLinkServiceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoData): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoData =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoData(
                applicationHostUrl = javaType.applicationHostUrl(),
                applicationServicePath = javaType.applicationServicePath(),
                clientNumber = javaType.clientNumber(),
                logonLanguage = javaType.logonLanguage().map({ args0 -> args0 }).orElse(null),
                oauthProperties = javaType.oauthProperties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSapoDataOauthProperties.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                portNumber = javaType.portNumber(),
                privateLinkServiceName = javaType.privateLinkServiceName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
