@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountName The name of the account.
 * @property bucketName
 * @property bucketPrefix
 * @property privateLinkServiceName
 * @property region AWS Region of the Snowflake account.
 * @property stage Name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: `<Database>.<Schema>.<Stage Name>`.
 * @property warehouse The name of the Snowflake warehouse.
 */
public data class ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflake(
    public val accountName: String? = null,
    public val bucketName: String,
    public val bucketPrefix: String? = null,
    public val privateLinkServiceName: String? = null,
    public val region: String? = null,
    public val stage: String,
    public val warehouse: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflake): ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflake =
            ConnectorProfileConnectorProfileConfigConnectorProfilePropertiesSnowflake(
                accountName = javaType.accountName().map({ args0 -> args0 }).orElse(null),
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                privateLinkServiceName = javaType.privateLinkServiceName().map({ args0 -> args0 }).orElse(null),
                region = javaType.region().map({ args0 -> args0 }).orElse(null),
                stage = javaType.stage(),
                warehouse = javaType.warehouse(),
            )
    }
}
