@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property customConnector Properties that are required to query the custom Connector. See Custom Connector Destination Properties for more details.
 * @property customerProfiles Properties that are required to query Amazon Connect Customer Profiles. See Customer Profiles Destination Properties for more details.
 * @property eventBridge Properties that are required to query Amazon EventBridge. See Generic Destination Properties for more details.
 * @property honeycode Properties that are required to query Amazon Honeycode. See Generic Destination Properties for more details.
 * @property lookoutMetrics
 * @property marketo Properties that are required to query Marketo. See Generic Destination Properties for more details.
 * @property redshift Properties that are required to query Amazon Redshift. See Redshift Destination Properties for more details.
 * @property s3 Properties that are required to query Amazon S3. See S3 Destination Properties for more details.
 * @property salesforce Properties that are required to query Salesforce. See Salesforce Destination Properties for more details.
 * @property sapoData Properties that are required to query SAPOData. See SAPOData Destination Properties for more details.
 * @property snowflake Properties that are required to query Snowflake. See Snowflake Destination Properties for more details.
 * @property upsolver Properties that are required to query Upsolver. See Upsolver Destination Properties for more details.
 * @property zendesk Properties that are required to query Zendesk. See Zendesk Destination Properties for more details.
 */
public data class FlowDestinationFlowConfigDestinationConnectorProperties(
    public val customConnector: FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnector? = null,
    public val customerProfiles: FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfiles? = null,
    public val eventBridge: FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridge? =
        null,
    public val honeycode: FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycode? = null,
    public val lookoutMetrics: FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetrics? =
        null,
    public val marketo: FlowDestinationFlowConfigDestinationConnectorPropertiesMarketo? = null,
    public val redshift: FlowDestinationFlowConfigDestinationConnectorPropertiesRedshift? = null,
    public val s3: FlowDestinationFlowConfigDestinationConnectorPropertiesS3? = null,
    public val salesforce: FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforce? = null,
    public val sapoData: FlowDestinationFlowConfigDestinationConnectorPropertiesSapoData? = null,
    public val snowflake: FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflake? = null,
    public val upsolver: FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolver? = null,
    public val zendesk: FlowDestinationFlowConfigDestinationConnectorPropertiesZendesk? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorProperties): FlowDestinationFlowConfigDestinationConnectorProperties =
            FlowDestinationFlowConfigDestinationConnectorProperties(
                customConnector = javaType.customConnector().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomConnector.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                customerProfiles = javaType.customerProfiles().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesCustomerProfiles.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                eventBridge = javaType.eventBridge().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesEventBridge.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                honeycode = javaType.honeycode().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycode.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lookoutMetrics = javaType.lookoutMetrics().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesLookoutMetrics.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                marketo = javaType.marketo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesMarketo.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                redshift = javaType.redshift().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesRedshift.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                s3 = javaType.s3().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesS3.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                salesforce = javaType.salesforce().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSalesforce.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sapoData = javaType.sapoData().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSapoData.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                snowflake = javaType.snowflake().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesSnowflake.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                upsolver = javaType.upsolver().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesUpsolver.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                zendesk = javaType.zendesk().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appflow.kotlin.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesZendesk.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
