@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appflow.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Name of the Amazon S3 bucket.
 * @property bucketPrefix Amazon S3 bucket prefix.
 * @property failOnFirstDestinationError If the flow should fail after the first instance of a failure when attempting to place data in the destination.
 */
public data class
FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfig(
    public val bucketName: String? = null,
    public val bucketPrefix: String? = null,
    public val failOnFirstDestinationError: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appflow.outputs.FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfig): FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfig =
            FlowDestinationFlowConfigDestinationConnectorPropertiesHoneycodeErrorHandlingConfig(
                bucketName = javaType.bucketName().map({ args0 -> args0 }).orElse(null),
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                failOnFirstDestinationError = javaType.failOnFirstDestinationError().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
